/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.impl;

import java.util.List;
import org.operaton.bpm.engine.exception.NotValidException;
import org.operaton.bpm.engine.history.ExternalTaskState;
import org.operaton.bpm.engine.history.HistoricExternalTaskLog;
import org.operaton.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.operaton.bpm.engine.impl.AbstractQuery;
import org.operaton.bpm.engine.impl.HistoricExternalTaskLogQueryProperty;
import org.operaton.bpm.engine.impl.Page;
import org.operaton.bpm.engine.impl.interceptor.CommandContext;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.util.EnsureUtil;
import org.operaton.commons.utils.CollectionUtil;

public class HistoricExternalTaskLogQueryImpl
extends AbstractQuery<HistoricExternalTaskLogQuery, HistoricExternalTaskLog>
implements HistoricExternalTaskLogQuery {
    private static final long serialVersionUID = 1L;
    private static final String VAR_ACTIVITY_IDS = "activityIds";
    private static final String VAR_ACTIVITY_INSTANCE_IDS = "activityInstanceIds";
    private static final String VAR_ERROR_MESSAGE = "errorMessage";
    private static final String VAR_EXECUTION_IDS = "executionIds";
    private static final String VAR_EXTERNAL_TASK_ID = "externalTaskId";
    private static final String VAR_HISTORIC_EXTERNAL_TASK_LOG_ID = "historicExternalTaskLogId";
    private static final String VAR_PROCESS_INSTANCE_ID = "processInstanceId";
    private static final String VAR_PROCESS_DEFINITION_ID = "processDefinitionId";
    private static final String VAR_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    private static final String VAR_TENANT_IDS = "tenantIds";
    private static final String VAR_TOPIC_NAME = "topicName";
    private static final String VAR_WORKER_ID = "workerId";
    protected String id;
    protected String externalTaskId;
    protected String topicName;
    protected String workerId;
    protected String errorMessage;
    protected String[] activityIds;
    protected String[] activityInstanceIds;
    protected String[] executionIds;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected Long priorityHigherThanOrEqual;
    protected Long priorityLowerThanOrEqual;
    protected String[] tenantIds;
    protected boolean isTenantIdSet;
    protected ExternalTaskState state;

    public HistoricExternalTaskLogQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricExternalTaskLogQuery logId(String historicExternalTaskLogId) {
        EnsureUtil.ensureNotNull(NotValidException.class, VAR_HISTORIC_EXTERNAL_TASK_LOG_ID, (Object)historicExternalTaskLogId);
        this.id = historicExternalTaskLogId;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery externalTaskId(String externalTaskId) {
        EnsureUtil.ensureNotNull(NotValidException.class, VAR_EXTERNAL_TASK_ID, (Object)externalTaskId);
        this.externalTaskId = externalTaskId;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery topicName(String topicName) {
        EnsureUtil.ensureNotNull(NotValidException.class, VAR_TOPIC_NAME, (Object)topicName);
        this.topicName = topicName;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery workerId(String workerId) {
        EnsureUtil.ensureNotNull(NotValidException.class, VAR_WORKER_ID, (Object)workerId);
        this.workerId = workerId;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery errorMessage(String errorMessage) {
        EnsureUtil.ensureNotNull(NotValidException.class, VAR_ERROR_MESSAGE, (Object)errorMessage);
        this.errorMessage = errorMessage;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery activityIdIn(String ... activityIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, VAR_ACTIVITY_IDS, (Object[])activityIds);
        List activityIdList = CollectionUtil.asArrayList((Object[])activityIds);
        EnsureUtil.ensureNotContainsNull(VAR_ACTIVITY_IDS, activityIdList);
        EnsureUtil.ensureNotContainsEmptyString(VAR_ACTIVITY_IDS, activityIdList);
        this.activityIds = activityIds;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery activityInstanceIdIn(String ... activityInstanceIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, VAR_ACTIVITY_IDS, (Object[])activityInstanceIds);
        List activityInstanceIdList = CollectionUtil.asArrayList((Object[])activityInstanceIds);
        EnsureUtil.ensureNotContainsNull(VAR_ACTIVITY_INSTANCE_IDS, activityInstanceIdList);
        EnsureUtil.ensureNotContainsEmptyString(VAR_ACTIVITY_INSTANCE_IDS, activityInstanceIdList);
        this.activityInstanceIds = activityInstanceIds;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery executionIdIn(String ... executionIds) {
        EnsureUtil.ensureNotNull(NotValidException.class, VAR_ACTIVITY_IDS, (Object[])executionIds);
        List executionIdList = CollectionUtil.asArrayList((Object[])executionIds);
        EnsureUtil.ensureNotContainsNull(VAR_EXECUTION_IDS, executionIdList);
        EnsureUtil.ensureNotContainsEmptyString(VAR_EXECUTION_IDS, executionIdList);
        this.executionIds = executionIds;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery processInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, VAR_PROCESS_INSTANCE_ID, (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, VAR_PROCESS_DEFINITION_ID, (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery processDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull(NotValidException.class, VAR_PROCESS_DEFINITION_KEY, (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull(VAR_TENANT_IDS, (Object[])tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery withoutTenantId() {
        this.tenantIds = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery priorityHigherThanOrEquals(long priority) {
        this.priorityHigherThanOrEqual = priority;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery priorityLowerThanOrEquals(long priority) {
        this.priorityLowerThanOrEqual = priority;
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery creationLog() {
        this.setState(ExternalTaskState.CREATED);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery failureLog() {
        this.setState(ExternalTaskState.FAILED);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery successLog() {
        this.setState(ExternalTaskState.SUCCESSFUL);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery deletionLog() {
        this.setState(ExternalTaskState.DELETED);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByTimestamp() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.TIMESTAMP);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByExternalTaskId() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.EXTERNAL_TASK_ID);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByRetries() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.RETRIES);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByPriority() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.PRIORITY);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByTopicName() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.TOPIC_NAME);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByWorkerId() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.WORKER_ID);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByActivityId() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.ACTIVITY_ID);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByActivityInstanceId() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.ACTIVITY_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByExecutionId() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.EXECUTION_ID);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByProcessInstanceId() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByProcessDefinitionId() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByProcessDefinitionKey() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.PROCESS_DEFINITION_KEY);
        return this;
    }

    @Override
    public HistoricExternalTaskLogQuery orderByTenantId() {
        this.orderBy(HistoricExternalTaskLogQueryProperty.TENANT_ID);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricExternalTaskLogManager().findHistoricExternalTaskLogsCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricExternalTaskLog> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricExternalTaskLogManager().findHistoricExternalTaskLogsByQueryCriteria(this, page);
    }

    protected void setState(ExternalTaskState state) {
        this.state = state;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }
}

