/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.authorization;

import java.util.EnumSet;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.authorization.Resources;

public enum Permissions implements Permission
{
    NONE("NONE", 0, EnumSet.allOf(Resources.class)),
    ALL("ALL", Integer.MAX_VALUE, EnumSet.allOf(Resources.class)),
    READ("READ", 2, EnumSet.of(Resources.AUTHORIZATION, new Resources[]{Resources.BATCH, Resources.DASHBOARD, Resources.DECISION_DEFINITION, Resources.DECISION_REQUIREMENTS_DEFINITION, Resources.DEPLOYMENT, Resources.FILTER, Resources.GROUP, Resources.PROCESS_DEFINITION, Resources.PROCESS_INSTANCE, Resources.REPORT, Resources.TASK, Resources.TENANT, Resources.USER})),
    UPDATE("UPDATE", 4, EnumSet.of(Resources.AUTHORIZATION, new Resources[]{Resources.BATCH, Resources.DASHBOARD, Resources.DECISION_DEFINITION, Resources.FILTER, Resources.GROUP, Resources.PROCESS_DEFINITION, Resources.PROCESS_INSTANCE, Resources.REPORT, Resources.TASK, Resources.TENANT, Resources.USER})),
    CREATE("CREATE", 8, EnumSet.of(Resources.AUTHORIZATION, new Resources[]{Resources.BATCH, Resources.DASHBOARD, Resources.DEPLOYMENT, Resources.FILTER, Resources.GROUP, Resources.GROUP_MEMBERSHIP, Resources.PROCESS_INSTANCE, Resources.REPORT, Resources.TASK, Resources.TENANT, Resources.TENANT_MEMBERSHIP, Resources.USER})),
    DELETE("DELETE", 16, EnumSet.of(Resources.AUTHORIZATION, new Resources[]{Resources.BATCH, Resources.DASHBOARD, Resources.DEPLOYMENT, Resources.FILTER, Resources.GROUP, Resources.GROUP_MEMBERSHIP, Resources.PROCESS_DEFINITION, Resources.PROCESS_INSTANCE, Resources.REPORT, Resources.TASK, Resources.TENANT, Resources.TENANT_MEMBERSHIP, Resources.USER})),
    ACCESS("ACCESS", 32, EnumSet.of(Resources.APPLICATION)),
    READ_TASK("READ_TASK", 64, EnumSet.of(Resources.PROCESS_DEFINITION)),
    UPDATE_TASK("UPDATE_TASK", 128, EnumSet.of(Resources.PROCESS_DEFINITION)),
    CREATE_INSTANCE("CREATE_INSTANCE", 256, EnumSet.of(Resources.DECISION_DEFINITION, Resources.PROCESS_DEFINITION)),
    READ_INSTANCE("READ_INSTANCE", 512, EnumSet.of(Resources.PROCESS_DEFINITION)),
    UPDATE_INSTANCE("UPDATE_INSTANCE", 1024, EnumSet.of(Resources.PROCESS_DEFINITION)),
    DELETE_INSTANCE("DELETE_INSTANCE", 2048, EnumSet.of(Resources.PROCESS_DEFINITION)),
    READ_HISTORY("READ_HISTORY", 4096, EnumSet.of(Resources.BATCH, Resources.DECISION_DEFINITION, Resources.PROCESS_DEFINITION, Resources.TASK)),
    DELETE_HISTORY("DELETE_HISTORY", 8192, EnumSet.of(Resources.BATCH, Resources.DECISION_DEFINITION, Resources.PROCESS_DEFINITION)),
    TASK_WORK("TASK_WORK", 16384, EnumSet.of(Resources.PROCESS_DEFINITION, Resources.TASK)),
    TASK_ASSIGN("TASK_ASSIGN", 32768, EnumSet.of(Resources.PROCESS_DEFINITION, Resources.TASK)),
    MIGRATE_INSTANCE("MIGRATE_INSTANCE", 65536, EnumSet.of(Resources.PROCESS_DEFINITION));

    private final String name;
    private final int id;
    private final Resource[] resourceTypes;

    private Permissions(String name, int id, EnumSet<Resources> resourceTypes) {
        this.name = name;
        this.id = id;
        this.resourceTypes = resourceTypes.toArray(new Resource[resourceTypes.size()]);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getValue() {
        return this.id;
    }

    @Override
    public Resource[] getTypes() {
        return this.resourceTypes;
    }

    public static Permission forName(String name) {
        return Permissions.valueOf(name);
    }
}

