/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.container.impl.deployment;

import java.util.List;
import org.operaton.bpm.application.AbstractProcessApplication;
import org.operaton.bpm.application.impl.metadata.spi.ProcessesXml;
import org.operaton.bpm.container.impl.ContainerIntegrationLogger;
import org.operaton.bpm.container.impl.jmx.services.JmxManagedProcessApplication;
import org.operaton.bpm.container.impl.metadata.spi.ProcessEngineXml;
import org.operaton.bpm.container.impl.spi.DeploymentOperation;
import org.operaton.bpm.container.impl.spi.DeploymentOperationStep;
import org.operaton.bpm.container.impl.spi.PlatformServiceContainer;
import org.operaton.bpm.container.impl.spi.ServiceTypes;
import org.operaton.bpm.engine.impl.ProcessEngineLogger;
import org.operaton.bpm.engine.impl.util.EnsureUtil;

public class ProcessesXmlStopProcessEnginesStep
extends DeploymentOperationStep {
    private static final ContainerIntegrationLogger LOG = ProcessEngineLogger.CONTAINER_INTEGRATION_LOGGER;

    @Override
    public String getName() {
        return "Stopping process engines";
    }

    @Override
    public void performOperationStep(DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        AbstractProcessApplication processApplication = (AbstractProcessApplication)operationContext.getAttachment("processApplication");
        JmxManagedProcessApplication deployedProcessApplication = (JmxManagedProcessApplication)serviceContainer.getService(ServiceTypes.PROCESS_APPLICATION, processApplication.getName());
        EnsureUtil.ensureNotNull("Cannot find process application with name " + processApplication.getName(), "deployedProcessApplication", (Object)deployedProcessApplication);
        List<ProcessesXml> processesXmls = deployedProcessApplication.getProcessesXmls();
        for (ProcessesXml processesXml : processesXmls) {
            this.stopProcessEngines(processesXml.getProcessEngines(), operationContext);
        }
    }

    protected void stopProcessEngines(List<ProcessEngineXml> processEngine, DeploymentOperation operationContext) {
        for (ProcessEngineXml parsedProcessEngine : processEngine) {
            this.stopProcessEngine(parsedProcessEngine.getName(), operationContext);
        }
    }

    protected void stopProcessEngine(String processEngineName, DeploymentOperation operationContext) {
        PlatformServiceContainer serviceContainer = operationContext.getServiceContainer();
        try {
            serviceContainer.stopService(ServiceTypes.PROCESS_ENGINE, processEngineName);
        }
        catch (Exception e) {
            LOG.exceptionWhileStopping("Process Engine", processEngineName, e);
        }
    }
}

