/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.assertj.core.api.Assertions;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.type.ValueType;
import org.operaton.bpm.engine.variable.value.ObjectValue;
import org.operaton.bpm.engine.variable.value.TypedValue;

public final class TypedValueAssert {
    public static void assertObjectValueDeserializedNull(ObjectValue typedValue) {
        Assertions.assertThat((Object)typedValue).isNotNull();
        Assertions.assertThat((boolean)typedValue.isDeserialized()).isTrue();
        Assertions.assertThat((String)typedValue.getSerializationDataFormat()).isNotNull();
        Assertions.assertThat((Object)typedValue.getValue()).isNull();
        Assertions.assertThat((String)typedValue.getValueSerialized()).isNull();
        Assertions.assertThat((Class)typedValue.getObjectType()).isNull();
        Assertions.assertThat((String)typedValue.getObjectTypeName()).isNull();
    }

    public static void assertObjectValueSerializedNull(ObjectValue typedValue) {
        Assertions.assertThat((Object)typedValue).isNotNull();
        Assertions.assertThat((boolean)typedValue.isDeserialized()).isFalse();
        Assertions.assertThat((String)typedValue.getSerializationDataFormat()).isNotNull();
        Assertions.assertThat((String)typedValue.getValueSerialized()).isNull();
        Assertions.assertThat((String)typedValue.getObjectTypeName()).isNull();
    }

    public static void assertObjectValueDeserialized(ObjectValue typedValue, Object value) {
        Class<?> expectedObjectType = value.getClass();
        Assertions.assertThat((boolean)typedValue.isDeserialized()).isTrue();
        Assertions.assertThat((Object)typedValue.getType()).isEqualTo((Object)ValueType.OBJECT);
        Assertions.assertThat((Object)typedValue.getValue()).isEqualTo(value);
        Assertions.assertThat((Object)typedValue.getValue(expectedObjectType)).isEqualTo(value);
        Assertions.assertThat((Class)typedValue.getObjectType()).isEqualTo(expectedObjectType);
        Assertions.assertThat((String)typedValue.getObjectTypeName()).isEqualTo(expectedObjectType.getName());
    }

    public static void assertObjectValueSerializedJava(ObjectValue typedValue, Object value) {
        Assertions.assertThat((String)typedValue.getSerializationDataFormat()).isEqualTo(Variables.SerializationDataFormats.JAVA.getName());
        try {
            String valueSerialized = typedValue.getValueSerialized();
            byte[] decodedObject = Base64.getDecoder().decode(valueSerialized.getBytes(StandardCharsets.UTF_8));
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(decodedObject));
            Assertions.assertThat((Object)objectInputStream.readObject()).isEqualTo(value);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertUntypedNullValue(TypedValue nullValue) {
        Assertions.assertThat((Object)nullValue).isNotNull();
        Assertions.assertThat((Object)nullValue.getValue()).isNull();
        Assertions.assertThat((Object)nullValue.getType()).isEqualTo((Object)ValueType.NULL);
    }

    private TypedValueAssert() {
    }
}

