/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.util;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.query.Query;

public final class QueryTestHelper {
    private QueryTestHelper() {
    }

    public static void verifyQueryResults(Query<?, ?> query, int countExpected) {
        Assertions.assertThat((List)query.list()).hasSize(countExpected);
        Assertions.assertThat((long)query.count()).isEqualTo((long)countExpected);
        if (countExpected == 1) {
            Assertions.assertThat((Object)query.singleResult()).isNotNull();
        } else if (countExpected > 1) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> query.singleResult()).isInstanceOf(ProcessEngineException.class)).hasMessageMatching("Query return \\d+ results instead of max 1");
        } else if (countExpected == 0) {
            Assertions.assertThat((Object)query.singleResult()).isNull();
        }
    }
}

