/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.operaton.bpm.engine.migration.MigrationInstructionValidationReport;
import org.operaton.bpm.engine.migration.MigrationPlanValidationReport;
import org.operaton.bpm.engine.migration.MigrationVariableValidationReport;

public class MigrationPlanValidationReportAssert {
    protected MigrationPlanValidationReport actual;

    public MigrationPlanValidationReportAssert(MigrationPlanValidationReport report) {
        this.actual = report;
    }

    public MigrationPlanValidationReportAssert isNotNull() {
        ((ObjectAssert)Assertions.assertThat((Object)this.actual).as("Expected report to be not null", new Object[0])).isNotNull();
        return this;
    }

    public MigrationPlanValidationReportAssert hasVariableFailures(String name, String ... expectedFailures) {
        this.isNotNull();
        ArrayList failuresFound = new ArrayList();
        this.actual.getVariableReports().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(name)).findFirst().ifPresent(entry -> failuresFound.addAll(((MigrationVariableValidationReport)entry.getValue()).getFailures()));
        ((ListAssert)Assertions.assertThat(failuresFound).as("Expected failures for variable name '%s':\n%sBut found failures:\n%s", new Object[]{name, this.joinFailures(expectedFailures), this.joinFailures(failuresFound.toArray())})).containsExactlyInAnyOrder((Object[])expectedFailures);
        return this;
    }

    public MigrationPlanValidationReportAssert hasInstructionFailures(String activityId, String ... expectedFailures) {
        this.isNotNull();
        ArrayList failuresFound = new ArrayList();
        for (MigrationInstructionValidationReport instructionReport : this.actual.getInstructionReports()) {
            String sourceActivityId = instructionReport.getMigrationInstruction().getSourceActivityId();
            if ((activityId != null || sourceActivityId != null) && (activityId == null || !activityId.equals(sourceActivityId))) continue;
            failuresFound.addAll(instructionReport.getFailures());
        }
        ((ListAssert)((ListAssert)Assertions.assertThat(failuresFound).as("Expected failures for activity id '%s':%n%s%nBut found failures:%n%s", new Object[]{activityId, this.joinFailures(expectedFailures), this.joinFailures(failuresFound.toArray())})).hasSize(expectedFailures.length)).allMatch(failure -> Arrays.stream(expectedFailures).anyMatch(failure::startsWith));
        return this;
    }

    public static MigrationPlanValidationReportAssert assertThat(MigrationPlanValidationReport report) {
        return new MigrationPlanValidationReportAssert(report);
    }

    public String joinFailures(Object[] failures) {
        StringBuilder builder = new StringBuilder();
        for (Object failure : failures) {
            builder.append("\t\t").append(failure).append("\n");
        }
        return builder.toString();
    }
}

