/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.util;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.operaton.bpm.engine.migration.MigratingActivityInstanceValidationReport;
import org.operaton.bpm.engine.migration.MigratingProcessInstanceValidationReport;
import org.operaton.bpm.engine.migration.MigratingTransitionInstanceValidationReport;
import org.operaton.bpm.engine.runtime.ProcessInstance;

public class MigratingProcessInstanceValidationReportAssert {
    protected MigratingProcessInstanceValidationReport actual;

    public MigratingProcessInstanceValidationReportAssert(MigratingProcessInstanceValidationReport report) {
        this.actual = report;
    }

    public MigratingProcessInstanceValidationReportAssert isNotNull() {
        ((ObjectAssert)Assertions.assertThat((Object)this.actual).as("Expected report to be not null", new Object[0])).isNotNull();
        return this;
    }

    public MigratingProcessInstanceValidationReportAssert hasProcessInstance(ProcessInstance processInstance) {
        return this.hasProcessInstanceId(processInstance.getId());
    }

    public MigratingProcessInstanceValidationReportAssert hasProcessInstanceId(String processInstanceId) {
        this.isNotNull();
        ((AbstractStringAssert)Assertions.assertThat((String)this.actual.getProcessInstanceId()).as("Expected report to be for process instance", new Object[0])).isEqualTo(processInstanceId);
        return this;
    }

    public MigratingProcessInstanceValidationReportAssert hasActivityInstanceFailures(String sourceScopeId, String ... expectedFailures) {
        this.isNotNull();
        MigratingActivityInstanceValidationReport actualReport = null;
        for (MigratingActivityInstanceValidationReport instanceReport : this.actual.getActivityInstanceReports()) {
            if (!sourceScopeId.equals(instanceReport.getSourceScopeId())) continue;
            actualReport = instanceReport;
            break;
        }
        ((ObjectAssert)Assertions.assertThat(actualReport).as("No validation report found for source scope: " + sourceScopeId, new Object[0])).isNotNull();
        this.assertFailures(sourceScopeId, Arrays.asList(expectedFailures), actualReport.getFailures());
        return this;
    }

    public MigratingProcessInstanceValidationReportAssert hasTransitionInstanceFailures(String sourceScopeId, String ... expectedFailures) {
        this.isNotNull();
        MigratingTransitionInstanceValidationReport actualReport = null;
        for (MigratingTransitionInstanceValidationReport instanceReport : this.actual.getTransitionInstanceReports()) {
            if (!sourceScopeId.equals(instanceReport.getSourceScopeId())) continue;
            actualReport = instanceReport;
            break;
        }
        ((ObjectAssert)Assertions.assertThat(actualReport).as("No validation report found for source scope: " + sourceScopeId, new Object[0])).isNotNull();
        this.assertFailures(sourceScopeId, Arrays.asList(expectedFailures), actualReport.getFailures());
        return this;
    }

    protected void assertFailures(String sourceScopeId, List<String> expectedFailures, List<String> actualFailures) {
        List<String> unmatchedFailures = expectedFailures.stream().filter(expected -> actualFailures.stream().noneMatch(failure -> failure.contains((CharSequence)expected))).toList();
        ((ListAssert)Assertions.assertThat(unmatchedFailures).as("Expected failures for source scope: %s%nExpected:%n%s%nBut found:%n%s", new Object[]{sourceScopeId, this.joinFailures(expectedFailures), this.joinFailures(actualFailures)})).isEmpty();
    }

    public static MigratingProcessInstanceValidationReportAssert assertThat(MigratingProcessInstanceValidationReport report) {
        return new MigratingProcessInstanceValidationReportAssert(report);
    }

    public String joinFailures(List<String> failures) {
        StringBuilder builder = new StringBuilder();
        for (String failure : failures) {
            builder.append("\t\t").append((Object)failure).append("\n");
        }
        return builder.toString();
    }
}

