/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.util;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.operaton.bpm.BpmPlatform;
import org.operaton.bpm.ProcessEngineService;
import org.operaton.bpm.engine.ManagementService;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineConfiguration;
import org.operaton.bpm.engine.ProcessEngineException;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.jobexecutor.JobExecutor;
import org.operaton.bpm.engine.impl.jobexecutor.ThreadPoolJobExecutor;

public final class JobExecutorWaitUtils {
    public static final long CHECK_INTERVAL_MS = 250L;
    public static final long JOBS_WAIT_TIMEOUT_MS = 20000L;
    private static final int JOB_EXECUTOR_WAIT_MULTIPLIER = 2;
    private static final int THREAD_POOL_ACTIVE_COUNT_ZERO = 0;

    private JobExecutorWaitUtils() {
    }

    public static void waitForJobExecutorToProcessAllJobs() {
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(20000L);
    }

    public static void waitForJobExecutorToProcessAllJobs(long maxMillisToWait) {
        ProcessEngine processEngine = JobExecutorWaitUtils.getProcessEngine();
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(processEngine.getProcessEngineConfiguration(), maxMillisToWait);
    }

    public static void waitForJobExecutorToProcessAllJobs(ProcessEngineConfiguration processEngineConfiguration, long maxMillisToWait) {
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(processEngineConfiguration, maxMillisToWait, 250L);
    }

    private static long calculateMaxWaitTime(JobExecutor jobExecutor, long maxMillisToWait) {
        int jobExecutorWaitTime = jobExecutor.getWaitTimeInMillis() * 2;
        if (maxMillisToWait < (long)jobExecutorWaitTime) {
            maxMillisToWait = jobExecutorWaitTime;
        }
        return maxMillisToWait;
    }

    public static void waitForJobExecutorToProcessAllJobs(ProcessEngineConfiguration processEngineConfiguration, long maxMillisToWait, long checkInterval) {
        JobExecutor jobExecutor = ((ProcessEngineConfigurationImpl)processEngineConfiguration).getJobExecutor();
        ManagementService managementService = ((ProcessEngineConfigurationImpl)processEngineConfiguration).getManagementService();
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(maxMillisToWait, checkInterval, jobExecutor, managementService);
    }

    public static void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long checkInterval, JobExecutor jobExecutor, ManagementService managementService) {
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(maxMillisToWait, checkInterval, jobExecutor, managementService, () -> !JobExecutorWaitUtils.hasPendingJobs(managementService));
    }

    public static void waitForJobExecutorToProcessAllJobs(String processInstanceId, long maxMillisToWait, long checkInterval, JobExecutor jobExecutor, ManagementService managementService) {
        JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(maxMillisToWait, checkInterval, jobExecutor, managementService, () -> !JobExecutorWaitUtils.hasPendingJobsByPiId(processInstanceId, managementService));
    }

    private static void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long checkInterval, JobExecutor jobExecutor, ManagementService managementService, Callable<Boolean> waitForCondition) {
        boolean shutdown = false;
        maxMillisToWait = JobExecutorWaitUtils.calculateMaxWaitTime(jobExecutor, maxMillisToWait);
        try {
            shutdown = JobExecutorWaitUtils.activateJobExecutor(jobExecutor);
            JobExecutorWaitUtils.waitForCondition(waitForCondition, maxMillisToWait, checkInterval);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Time limit of " + maxMillisToWait + " was exceeded (still " + JobExecutorWaitUtils.numberOfJobsAvailable(managementService) + " jobs available)", (Throwable)e);
        }
        finally {
            if (shutdown) {
                jobExecutor.shutdown();
            }
        }
    }

    public static void waitForJobExecutionRunnablesToFinish(long maxMillisToWait, long intervalMillis, JobExecutor jobExecutor) {
        JobExecutorWaitUtils.waitForCondition(() -> ((ThreadPoolJobExecutor)jobExecutor).getThreadPoolExecutor().getActiveCount() == 0, maxMillisToWait, intervalMillis);
    }

    public static void waitForCondition(Callable<Boolean> condition, long maxMillisToWait, long checkInterval) {
        if (maxMillisToWait < checkInterval) {
            checkInterval = maxMillisToWait;
        }
        try {
            Awaitility.await().atMost(maxMillisToWait, TimeUnit.MILLISECONDS).pollInterval(checkInterval, TimeUnit.MILLISECONDS).ignoreExceptions().until(condition);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Time limit of " + maxMillisToWait + " was exceeded.");
        }
    }

    private static boolean activateJobExecutor(JobExecutor jobExecutor) {
        if (jobExecutor.isActive()) {
            return false;
        }
        jobExecutor.start();
        return true;
    }

    private static boolean hasPendingJobsByPiId(String processInstanceId, ManagementService managementService) {
        return managementService.createJobQuery().withRetriesLeft().executable().active().processInstanceId(processInstanceId).count() > 0L;
    }

    private static boolean hasPendingJobs(ManagementService managementService) {
        return JobExecutorWaitUtils.numberOfJobsAvailable(managementService) > 0L;
    }

    private static long numberOfJobsAvailable(ManagementService managementService) {
        return managementService.createJobQuery().withRetriesLeft().executable().active().count();
    }

    static ProcessEngine getProcessEngine() {
        ProcessEngineService processEngineService = BpmPlatform.getProcessEngineService();
        return processEngineService.getDefaultProcessEngine();
    }
}

