/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.util;

import org.operaton.bpm.engine.ManagementService;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineConfiguration;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.jobexecutor.JobExecutor;
import org.operaton.bpm.engine.test.util.JobExecutorWaitUtils;

public final class JobExecutorAssert {
    private ProcessEngine processEngine;
    private ProcessEngineConfiguration processEngineConfiguration;
    private JobExecutor jobExecutor;
    private ManagementService managementService;
    private String processInstanceId;
    private long timeoutMillis = 20000L;
    private long checkIntervalMillis = 250L;
    private boolean shutdownExecutorAfter;

    private JobExecutorAssert() {
    }

    public static JobExecutorAssert assertThatJobExecutor() {
        return new JobExecutorAssert();
    }

    public JobExecutorAssert withProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.processEngineConfiguration = processEngine.getProcessEngineConfiguration();
        return this;
    }

    public JobExecutorAssert withProcessEngineConfiguration(ProcessEngineConfiguration configuration) {
        this.processEngineConfiguration = configuration;
        if (configuration instanceof ProcessEngineConfigurationImpl) {
            ProcessEngineConfigurationImpl impl = (ProcessEngineConfigurationImpl)configuration;
            this.jobExecutor = impl.getJobExecutor();
            this.managementService = impl.getManagementService();
        }
        return this;
    }

    public JobExecutorAssert withJobExecutor(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
        return this;
    }

    public JobExecutorAssert withManagementService(ManagementService managementService) {
        this.managementService = managementService;
        return this;
    }

    public JobExecutorAssert withProcessInstance(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public JobExecutorAssert withTimeout(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public JobExecutorAssert withCheckInterval(long checkIntervalMillis) {
        this.checkIntervalMillis = checkIntervalMillis;
        return this;
    }

    public JobExecutorAssert shutdownExecutorAfter(boolean shutdown) {
        this.shutdownExecutorAfter = shutdown;
        return this;
    }

    public void hasAllJobsProcessed() {
        this.resolveMissingConfiguration();
        boolean wasActive = this.jobExecutor.isActive();
        if (this.processInstanceId != null) {
            JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(this.processInstanceId, this.timeoutMillis, this.checkIntervalMillis, this.jobExecutor, this.managementService);
        } else {
            JobExecutorWaitUtils.waitForJobExecutorToProcessAllJobs(this.timeoutMillis, this.checkIntervalMillis, this.jobExecutor, this.managementService);
        }
        if (this.shutdownExecutorAfter && this.jobExecutor.isActive()) {
            this.jobExecutor.shutdown();
        } else if (wasActive || this.jobExecutor.isActive()) {
            // empty if block
        }
    }

    protected void resolveMissingConfiguration() {
        if (this.jobExecutor != null && this.managementService != null) {
            return;
        }
        if (this.processEngineConfiguration == null) {
            if (this.processEngine != null) {
                this.processEngineConfiguration = this.processEngine.getProcessEngineConfiguration();
            } else {
                this.processEngine = JobExecutorWaitUtils.getProcessEngine();
                this.processEngineConfiguration = this.processEngine.getProcessEngineConfiguration();
            }
        }
        if (this.jobExecutor == null || this.managementService == null) {
            ProcessEngineConfigurationImpl impl = (ProcessEngineConfigurationImpl)this.processEngineConfiguration;
            if (this.jobExecutor == null) {
                this.jobExecutor = impl.getJobExecutor();
            }
            if (this.managementService == null) {
                this.managementService = impl.getManagementService();
            }
        }
    }
}

