/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.util;

import java.util.ArrayList;
import java.util.List;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.interceptor.CommandExecutor;
import org.operaton.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.operaton.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.operaton.bpm.engine.runtime.Execution;

public class ExecutionTree
implements Execution {
    protected ExecutionTree parent;
    protected List<ExecutionTree> children;
    protected Execution wrappedExecution;

    protected ExecutionTree(Execution execution, List<ExecutionTree> children) {
        this.wrappedExecution = execution;
        this.children = children;
        for (ExecutionTree child : children) {
            child.parent = this;
        }
    }

    public static ExecutionTree forExecution(String executionId, ProcessEngine processEngine) {
        ProcessEngineConfigurationImpl configuration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        CommandExecutor commandExecutor = configuration.getCommandExecutorTxRequired();
        return (ExecutionTree)commandExecutor.execute(commandContext -> {
            ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(executionId);
            return ExecutionTree.forExecution(execution);
        });
    }

    protected static ExecutionTree forExecution(ExecutionEntity execution) {
        ArrayList<ExecutionTree> children = new ArrayList<ExecutionTree>();
        for (ExecutionEntity child : execution.getExecutions()) {
            children.add(ExecutionTree.forExecution(child));
        }
        return new ExecutionTree((Execution)execution, children);
    }

    public List<ExecutionTree> getExecutions() {
        return this.children;
    }

    public List<ExecutionTree> getLeafExecutions(String activityId) {
        ArrayList<ExecutionTree> executions = new ArrayList<ExecutionTree>();
        for (ExecutionTree child : this.children) {
            if (!Boolean.FALSE.equals(child.isEventScope())) continue;
            if (child.getActivityId() != null) {
                if (!activityId.equals(child.getActivityId())) continue;
                executions.add(child);
                continue;
            }
            executions.addAll(child.getLeafExecutions(activityId));
        }
        return executions;
    }

    public String getId() {
        return this.wrappedExecution.getId();
    }

    public boolean isSuspended() {
        return this.wrappedExecution.isSuspended();
    }

    public boolean isEnded() {
        return this.wrappedExecution.isEnded();
    }

    public String getProcessInstanceId() {
        return this.wrappedExecution.getProcessInstanceId();
    }

    public ExecutionTree getParent() {
        return this.parent;
    }

    public String getActivityId() {
        return ((PvmExecutionImpl)this.wrappedExecution).getActivityId();
    }

    public Boolean isScope() {
        return ((PvmExecutionImpl)this.wrappedExecution).isScope();
    }

    public Boolean isConcurrent() {
        return ((PvmExecutionImpl)this.wrappedExecution).isConcurrent();
    }

    public Boolean isEventScope() {
        return ((PvmExecutionImpl)this.wrappedExecution).isEventScope();
    }

    public String getTenantId() {
        return this.wrappedExecution.getTenantId();
    }

    public Execution getExecution() {
        return this.wrappedExecution;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendString("", sb);
        return sb.toString();
    }

    public void appendString(String prefix, StringBuilder sb) {
        sb.append(prefix);
        sb.append(ExecutionTree.executionTreeToString(this));
        sb.append("\n");
        for (ExecutionTree child : this.getExecutions()) {
            child.appendString(prefix + "   ", sb);
        }
    }

    protected static String executionTreeToString(ExecutionTree executionTree) {
        StringBuilder sb = new StringBuilder();
        sb.append(executionTree.getExecution());
        sb.append("[activityId=");
        sb.append(executionTree.getActivityId());
        sb.append(", isScope=");
        sb.append(executionTree.isScope());
        sb.append(", isConcurrent=");
        sb.append(executionTree.isConcurrent());
        sb.append(", isEventScope=");
        sb.append(executionTree.isEventScope());
        sb.append("]");
        return sb.toString();
    }

    public String getProcessDefinitionKey() {
        return this.wrappedExecution.getProcessDefinitionKey();
    }
}

