/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.test.util.ProcessEngineTestRule;
import org.operaton.bpm.engine.test.util.Removable;
import org.operaton.bpm.engine.test.util.RemoveAfter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRemoveRule
extends TestWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(EntityRemoveRule.class);
    protected Removable removable;

    private EntityRemoveRule() {
        this.removable = Removable.of((ProcessEngine)null);
    }

    private EntityRemoveRule(ProcessEngineTestRule engineTestRule) {
        this.removable = Removable.of(engineTestRule);
    }

    public static EntityRemoveRule of(ProcessEngineTestRule rule) {
        return new EntityRemoveRule(rule);
    }

    public static EntityRemoveRule ofLazyRule(Supplier<ProcessEngineTestRule> ruleSupplier) {
        return new LazyEntityRemoveRuleProxy(ruleSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement apply(final Statement base, Description description) {
        final RemoveAfter removeAfterAnnotation = this.getAnnotation(description, RemoveAfter.class);
        final boolean methodHasRemoveAfterAnnotation = removeAfterAnnotation != null;
        try {
            Statement statement = new Statement(){

                public void evaluate() throws Throwable {
                    base.evaluate();
                    EntityRemoveRule.this.executePostEvaluate(removeAfterAnnotation, methodHasRemoveAfterAnnotation);
                }
            };
            return statement;
        }
        finally {
            LOG.debug("deleteTasks: {}", (Object)methodHasRemoveAfterAnnotation);
        }
    }

    protected void executePostEvaluate(RemoveAfter removeAfterAnnotation, boolean methodHasRemoveAfterAnnotation) {
        if (!methodHasRemoveAfterAnnotation) {
            return;
        }
        this.executePreRemoval();
        this.executeRemoval(removeAfterAnnotation);
    }

    protected void executePreRemoval() {
    }

    protected void executeRemoval(RemoveAfter removeAfterAnnotation) {
        if (this.hasZeroArguments(removeAfterAnnotation)) {
            this.removable.removeAll();
            return;
        }
        this.removable.remove(removeAfterAnnotation.value());
    }

    private boolean hasZeroArguments(RemoveAfter annotation) {
        return annotation.value() == null || annotation.value().length == 0;
    }

    private <T extends Annotation> T getAnnotation(Description description, Class<T> annotation) {
        String methodName = description.getMethodName();
        try {
            Class testClass = description.getTestClass();
            String methodWithoutParamsName = methodName.split("\\[")[0];
            Method method = testClass.getMethod(methodWithoutParamsName, new Class[0]);
            return method.getAnnotation(annotation);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to fetch annotation | annotationName: " + annotation.getName() + ", methodName: " + methodName, e);
        }
    }

    private static class LazyEntityRemoveRuleProxy
    extends EntityRemoveRule {
        private Supplier<ProcessEngineTestRule> supplier;

        public LazyEntityRemoveRuleProxy(Supplier<ProcessEngineTestRule> supplier) {
            this.supplier = supplier;
        }

        @Override
        protected void executePreRemoval() {
            this.removable = Removable.of(this.supplier.get());
        }
    }
}

