/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.api.runtime;

import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.operaton.bpm.engine.BadUserRequestException;
import org.operaton.bpm.engine.HistoryService;
import org.operaton.bpm.engine.IdentityService;
import org.operaton.bpm.engine.ManagementService;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineProvider;
import org.operaton.bpm.engine.RuntimeService;
import org.operaton.bpm.engine.batch.Batch;
import org.operaton.bpm.engine.batch.history.HistoricBatch;
import org.operaton.bpm.engine.history.HistoricJobLog;
import org.operaton.bpm.engine.history.HistoricJobLogQuery;
import org.operaton.bpm.engine.impl.util.ClockUtil;
import org.operaton.bpm.engine.management.JobDefinition;
import org.operaton.bpm.engine.runtime.Job;

public class BatchHelper {
    private final ProcessEngineProvider processEngineProvider;

    public BatchHelper(ProcessEngineProvider processEngineProvider) {
        this.processEngineProvider = processEngineProvider;
    }

    public Job getJobForDefinition(JobDefinition jobDefinition) {
        if (jobDefinition != null) {
            return (Job)this.getManagementService().createJobQuery().jobDefinitionId(jobDefinition.getId()).singleResult();
        }
        return null;
    }

    public List<Job> getJobsForDefinition(JobDefinition jobDefinition) {
        return this.getManagementService().createJobQuery().jobDefinitionId(jobDefinition.getId()).list();
    }

    public void executeJob(Job job) {
        ((ObjectAssert)Assertions.assertThat((Object)job).withFailMessage(() -> "Job to execute does not exist")).isNotNull();
        try {
            this.getManagementService().executeJob(job.getId());
        }
        catch (BadUserRequestException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JobDefinition getSeedJobDefinition(Batch batch) {
        return (JobDefinition)this.getManagementService().createJobDefinitionQuery().jobDefinitionId(batch.getSeedJobDefinitionId()).jobType("batch-seed-job").singleResult();
    }

    public Job getSeedJob(Batch batch) {
        return this.getJobForDefinition(this.getSeedJobDefinition(batch));
    }

    public void executeSeedJob(Batch batch) {
        this.executeJob(this.getSeedJob(batch));
    }

    public JobDefinition getMonitorJobDefinition(Batch batch) {
        return (JobDefinition)this.getManagementService().createJobDefinitionQuery().jobDefinitionId(batch.getMonitorJobDefinitionId()).jobType("batch-monitor-job").singleResult();
    }

    public Job getMonitorJob(Batch batch) {
        return this.getJobForDefinition(this.getMonitorJobDefinition(batch));
    }

    public void executeMonitorJob(Batch batch) {
        this.executeJob(this.getMonitorJob(batch));
    }

    public void completeMonitorJobs(Batch batch) {
        while (this.getMonitorJob(batch) != null) {
            this.executeMonitorJob(batch);
        }
    }

    public void completeSeedJobs(Batch batch) {
        while (this.getSeedJob(batch) != null) {
            this.executeSeedJob(batch);
        }
    }

    public JobDefinition getExecutionJobDefinition(Batch batch) {
        throw new AssertionError((Object)"This method is not implemented");
    }

    public JobDefinition getExecutionJobDefinition(Batch batch, String jobType) {
        return (JobDefinition)this.processEngineProvider.getProcessEngine().getManagementService().createJobDefinitionQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).jobType(jobType).singleResult();
    }

    public List<Job> getExecutionJobs(Batch batch) {
        return this.getJobsForDefinition(this.getExecutionJobDefinition(batch));
    }

    public List<Job> getExecutionJobs(Batch batch, String jobType) {
        return this.getJobsForDefinition(this.getExecutionJobDefinition(batch, jobType));
    }

    public void executeJobs(Batch batch) {
        for (Job job : this.getExecutionJobs(batch)) {
            this.executeJob(job);
        }
    }

    public void completeBatch(Batch batch) {
        this.completeSeedJobs(batch);
        this.completeExecutionJobs(batch);
        this.completeMonitorJobs(batch);
    }

    public void completeJobs(Batch batch, int count) {
        List<Job> jobs = this.getExecutionJobs(batch);
        Assertions.assertThat(jobs).hasSizeGreaterThanOrEqualTo(count);
        for (int i = 0; i < count; ++i) {
            this.executeJob(jobs.get(i));
        }
    }

    public void failExecutionJobs(Batch batch, int count) {
        this.setRetries(batch, count, 0);
    }

    public void setRetries(Batch batch, int count, int retries) {
        List<Job> jobs = this.getExecutionJobs(batch);
        Assertions.assertThat(jobs).hasSizeGreaterThanOrEqualTo(count);
        ManagementService managementService = this.getManagementService();
        for (int i = 0; i < count; ++i) {
            managementService.setJobRetries(jobs.get(i).getId(), retries);
        }
    }

    public void completeExecutionJobs(Batch batch) {
        while (!this.getExecutionJobs(batch).isEmpty()) {
            this.executeJobs(batch);
        }
    }

    public HistoricBatch getHistoricBatch(Batch batch) {
        return (HistoricBatch)this.getHistoryService().createHistoricBatchQuery().batchId(batch.getId()).singleResult();
    }

    public List<HistoricJobLog> getHistoricSeedJobLog(Batch batch) {
        return ((HistoricJobLogQuery)this.getHistoryService().createHistoricJobLogQuery().jobDefinitionId(batch.getSeedJobDefinitionId()).orderPartiallyByOccurrence().asc()).list();
    }

    public List<HistoricJobLog> getHistoricMonitorJobLog(Batch batch) {
        return ((HistoricJobLogQuery)this.getHistoryService().createHistoricJobLogQuery().jobDefinitionId(batch.getMonitorJobDefinitionId()).orderPartiallyByOccurrence().asc()).list();
    }

    public List<HistoricJobLog> getHistoricMonitorJobLog(Batch batch, Job monitorJob) {
        return ((HistoricJobLogQuery)this.getHistoryService().createHistoricJobLogQuery().jobDefinitionId(batch.getMonitorJobDefinitionId()).jobId(monitorJob.getId()).orderPartiallyByOccurrence().asc()).list();
    }

    public List<HistoricJobLog> getHistoricBatchJobLog(Batch batch) {
        return ((HistoricJobLogQuery)this.getHistoryService().createHistoricJobLogQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).orderPartiallyByOccurrence().asc()).list();
    }

    public Date addSeconds(Date date, int seconds) {
        return new Date(date.getTime() + (long)seconds * 1000L);
    }

    public Date addSecondsToClock(int seconds) {
        Date newDate = this.addSeconds(ClockUtil.getCurrentTime(), seconds);
        ClockUtil.setCurrentTime((Date)newDate);
        return newDate;
    }

    public void removeAllRunningAndHistoricBatches() {
        HistoryService historyService = this.getHistoryService();
        ManagementService managementService = this.getManagementService();
        for (Batch batch : managementService.createBatchQuery().list()) {
            managementService.deleteBatch(batch.getId(), true);
        }
        for (HistoricBatch historicBatch : historyService.createHistoricBatchQuery().list()) {
            historyService.deleteHistoricBatch(historicBatch.getId());
        }
    }

    protected ProcessEngine getProcessEngine() {
        return this.processEngineProvider.getProcessEngine();
    }

    protected RuntimeService getRuntimeService() {
        return this.getProcessEngine().getRuntimeService();
    }

    protected ManagementService getManagementService() {
        return this.getProcessEngine().getManagementService();
    }

    protected HistoryService getHistoryService() {
        return this.getProcessEngine().getHistoryService();
    }

    protected IdentityService getIdentityService() {
        return this.getProcessEngine().getIdentityService();
    }
}

