/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.api.authorization.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.operaton.bpm.engine.AuthorizationException;
import org.operaton.bpm.engine.AuthorizationService;
import org.operaton.bpm.engine.authorization.Authorization;
import org.operaton.bpm.engine.authorization.MissingAuthorization;
import org.operaton.bpm.engine.authorization.Permission;
import org.operaton.bpm.engine.authorization.Permissions;
import org.operaton.bpm.engine.authorization.Resource;
import org.operaton.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.operaton.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.operaton.bpm.engine.test.api.authorization.util.AuthorizationTestUtil;

public class AuthorizationScenarioInstance {
    protected AuthorizationScenario scenario;
    protected List<Authorization> createdAuthorizations = new ArrayList<Authorization>();
    protected List<Authorization> missingAuthorizations = new ArrayList<Authorization>();

    public AuthorizationScenarioInstance(AuthorizationScenario scenario, AuthorizationService authorizationService, Map<String, String> resourceBindings) {
        this.scenario = scenario;
        this.init(authorizationService, resourceBindings);
    }

    public void init(AuthorizationService authorizationService, Map<String, String> resourceBindings) {
        Authorization authorization;
        for (AuthorizationSpec authorizationSpec : this.scenario.getGivenAuthorizations()) {
            authorization = authorizationSpec.instantiate(authorizationService, resourceBindings);
            authorizationService.saveAuthorization(authorization);
            this.createdAuthorizations.add(authorization);
        }
        for (AuthorizationSpec authorizationSpec : this.scenario.getMissingAuthorizations()) {
            authorization = authorizationSpec.instantiate(authorizationService, resourceBindings);
            this.missingAuthorizations.add(authorization);
        }
    }

    public void tearDown(AuthorizationService authorizationService) {
        HashSet<String> activeAuthorizations = new HashSet<String>();
        for (Authorization activeAuthorization : authorizationService.createAuthorizationQuery().list()) {
            activeAuthorizations.add(activeAuthorization.getId());
        }
        for (Authorization createdAuthorization : this.createdAuthorizations) {
            if (!activeAuthorizations.contains(createdAuthorization.getId())) continue;
            authorizationService.deleteAuthorization(createdAuthorization.getId());
        }
    }

    public void assertAuthorizationException(AuthorizationException e) {
        if (!this.missingAuthorizations.isEmpty() && e != null) {
            String message = e.getMessage();
            List<MissingAuthorization> actualMissingAuthorizations = this.getActualMissingAuthorizations(e);
            ArrayList<MissingAuthorization> expectedMissingAuthorizations = new ArrayList<MissingAuthorization>();
            for (Authorization authorization : this.missingAuthorizations) {
                expectedMissingAuthorizations.add(AuthorizationScenarioInstance.asMissingAuthorization(authorization));
            }
            Assertions.assertThat(actualMissingAuthorizations).containsExactlyInAnyOrderElementsOf(expectedMissingAuthorizations);
            for (Authorization missingAuthorization : this.missingAuthorizations) {
                Permission[] permissions;
                Assertions.assertThat((String)message).contains(new CharSequence[]{missingAuthorization.getUserId()});
                Assertions.assertThat((String)e.getUserId()).isEqualTo(missingAuthorization.getUserId());
                for (Permission permission : permissions = AuthorizationTestUtil.getPermissions(missingAuthorization)) {
                    if (permission.getValue() == Permissions.NONE.getValue()) continue;
                    Assertions.assertThat((String)message).contains(new CharSequence[]{permission.getName()});
                    break;
                }
                if (!"*".equals(missingAuthorization.getResourceId())) {
                    Assertions.assertThat((String)message).contains(new CharSequence[]{missingAuthorization.getResourceId()});
                }
                Resource resource = AuthorizationTestUtil.getResourceByType(missingAuthorization.getResourceType());
                Assertions.assertThat((String)message).contains(new CharSequence[]{resource.resourceName()});
            }
        } else if (!this.missingAuthorizations.isEmpty() || e != null) {
            if (e != null) {
                Assertions.fail((String)this.describeScenarioFailure("Expected no authorization exception but got one: " + e.getMessage()));
            } else {
                Assertions.fail((String)this.describeScenarioFailure("Expected failure due to missing authorizations but code under test was successful"));
            }
        }
    }

    protected static MissingAuthorization asMissingAuthorization(Authorization authorization) {
        Permission[] permissions;
        String permissionName = null;
        String resourceId = null;
        String resourceName = null;
        for (Permission permission : permissions = AuthorizationTestUtil.getPermissions(authorization)) {
            if (permission.getValue() == Permissions.NONE.getValue()) continue;
            permissionName = permission.getName();
            break;
        }
        resourceId = authorization.getResourceId();
        Resource resource = AuthorizationTestUtil.getResourceByType(authorization.getResourceType());
        resourceName = resource.resourceName();
        return new MissingAuthorization(permissionName, resourceName, resourceId);
    }

    protected String describeScenarioFailure(String message) {
        return message + "\n\nScenario: \n" + this.scenario.toString();
    }

    protected List<MissingAuthorization> getActualMissingAuthorizations(AuthorizationException e) {
        ArrayList<MissingAuthorization> actualMissingAuthorizations = new ArrayList<MissingAuthorization>();
        for (MissingAuthorization missingAuthorization : e.getMissingAuthorizations()) {
            String violatedPermissionName = missingAuthorization.getViolatedPermissionName();
            String resourceType = missingAuthorization.getResourceType();
            String resourceId = missingAuthorization.getResourceId();
            if (resourceId == null) {
                resourceId = "*";
            }
            actualMissingAuthorizations.add(new MissingAuthorization(violatedPermissionName, resourceType, resourceId));
        }
        return actualMissingAuthorizations;
    }
}

