/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assume;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.operaton.bpm.engine.AuthorizationService;
import org.operaton.bpm.engine.CaseService;
import org.operaton.bpm.engine.DecisionService;
import org.operaton.bpm.engine.ExternalTaskService;
import org.operaton.bpm.engine.FilterService;
import org.operaton.bpm.engine.FormService;
import org.operaton.bpm.engine.HistoryService;
import org.operaton.bpm.engine.IdentityService;
import org.operaton.bpm.engine.ManagementService;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngineProvider;
import org.operaton.bpm.engine.ProcessEngineServices;
import org.operaton.bpm.engine.RepositoryService;
import org.operaton.bpm.engine.RuntimeService;
import org.operaton.bpm.engine.TaskService;
import org.operaton.bpm.engine.impl.ProcessEngineImpl;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.diagnostics.PlatformDiagnosticsRegistry;
import org.operaton.bpm.engine.impl.test.RequiredDatabase;
import org.operaton.bpm.engine.impl.test.TestHelper;
import org.operaton.bpm.engine.impl.util.ClockUtil;
import org.operaton.bpm.engine.test.Deployment;
import org.operaton.bpm.engine.test.RequiredHistoryLevel;

public class ProcessEngineRule
extends TestWatcher
implements ProcessEngineServices,
ProcessEngineProvider {
    protected String configurationResource = "operaton.cfg.xml";
    protected String configurationResourceCompat = "activiti.cfg.xml";
    protected String deploymentId;
    protected List<String> additionalDeployments = new ArrayList<String>();
    protected boolean ensureCleanAfterTest;
    protected ProcessEngine processEngine;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected FormService formService;
    protected FilterService filterService;
    protected AuthorizationService authorizationService;
    protected CaseService caseService;
    protected ExternalTaskService externalTaskService;
    protected DecisionService decisionService;

    public ProcessEngineRule() {
        this(false);
    }

    public ProcessEngineRule(boolean ensureCleanAfterTest) {
        this.ensureCleanAfterTest = ensureCleanAfterTest;
    }

    public ProcessEngineRule(String configurationResource) {
        this(configurationResource, false);
    }

    public ProcessEngineRule(String configurationResource, boolean ensureCleanAfterTest) {
        this.configurationResource = configurationResource;
        this.ensureCleanAfterTest = ensureCleanAfterTest;
    }

    public ProcessEngineRule(ProcessEngine processEngine) {
        this(processEngine, false);
    }

    public ProcessEngineRule(ProcessEngine processEngine, boolean ensureCleanAfterTest) {
        this.processEngine = processEngine;
        this.ensureCleanAfterTest = ensureCleanAfterTest;
    }

    public void starting(Description description) {
        String methodName = description.getMethodName();
        if (methodName != null) {
            int methodNameVariantStart = description.getMethodName().indexOf(91);
            int methodNameEnd = methodNameVariantStart < 0 ? description.getMethodName().length() : methodNameVariantStart;
            methodName = description.getMethodName().substring(0, methodNameEnd);
        }
        this.deploymentId = TestHelper.annotationDeploymentSetUp(this.processEngine, description.getTestClass(), methodName, (Deployment)description.getAnnotation(Deployment.class), new Class[0]);
    }

    public Statement apply(final Statement base, final Description description) {
        if (this.processEngine == null) {
            this.initializeProcessEngine();
        }
        this.initializeServices();
        Class testClass = description.getTestClass();
        String methodName = description.getMethodName();
        RequiredHistoryLevel reqHistoryLevel = (RequiredHistoryLevel)description.getAnnotation(RequiredHistoryLevel.class);
        final boolean hasRequiredHistoryLevel = TestHelper.annotationRequiredHistoryLevelCheck(this.processEngine, reqHistoryLevel, testClass, methodName);
        RequiredDatabase requiredDatabase = (RequiredDatabase)description.getAnnotation(RequiredDatabase.class);
        final boolean runsWithRequiredDatabase = TestHelper.annotationRequiredDatabaseCheck(this.processEngine, requiredDatabase, testClass, methodName, new Class[0]);
        return new Statement(){

            public void evaluate() throws Throwable {
                Assume.assumeTrue((String)"ignored because the current history level is too low", (boolean)hasRequiredHistoryLevel);
                Assume.assumeTrue((String)"ignored because the database doesn't match the required ones", (boolean)runsWithRequiredDatabase);
                ProcessEngineRule.super.apply(base, description).evaluate();
            }
        };
    }

    protected void initializeProcessEngine() {
        try {
            this.processEngine = TestHelper.getProcessEngine(this.configurationResource);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof FileNotFoundException) {
                this.processEngine = TestHelper.getProcessEngine(this.configurationResourceCompat);
            }
            throw ex;
        }
    }

    protected void initializeServices() {
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        this.repositoryService = this.processEngine.getRepositoryService();
        this.runtimeService = this.processEngine.getRuntimeService();
        this.taskService = this.processEngine.getTaskService();
        this.historyService = this.processEngine.getHistoryService();
        this.identityService = this.processEngine.getIdentityService();
        this.managementService = this.processEngine.getManagementService();
        this.formService = this.processEngine.getFormService();
        this.authorizationService = this.processEngine.getAuthorizationService();
        this.caseService = this.processEngine.getCaseService();
        this.filterService = this.processEngine.getFilterService();
        this.externalTaskService = this.processEngine.getExternalTaskService();
        this.decisionService = this.processEngine.getDecisionService();
    }

    protected void clearServiceReferences() {
        this.processEngineConfiguration = null;
        this.repositoryService = null;
        this.runtimeService = null;
        this.taskService = null;
        this.formService = null;
        this.historyService = null;
        this.identityService = null;
        this.managementService = null;
        this.authorizationService = null;
        this.caseService = null;
        this.filterService = null;
        this.externalTaskService = null;
        this.decisionService = null;
    }

    public void finished(Description description) {
        this.identityService.clearAuthentication();
        this.processEngine.getProcessEngineConfiguration().setTenantCheckEnabled(true);
        TestHelper.annotationDeploymentTearDown(this.processEngine, this.deploymentId, description.getTestClass(), description.getMethodName());
        for (String additionalDeployment : this.additionalDeployments) {
            TestHelper.deleteDeployment(this.processEngine, additionalDeployment);
        }
        if (this.ensureCleanAfterTest) {
            TestHelper.assertAndEnsureCleanDbAndCache(this.processEngine);
        }
        TestHelper.resetIdGenerator(this.processEngineConfiguration);
        ClockUtil.reset();
        this.clearServiceReferences();
        PlatformDiagnosticsRegistry.clear();
    }

    public void setCurrentTime(Date currentTime) {
        ClockUtil.setCurrentTime((Date)currentTime);
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public RuntimeService getRuntimeService() {
        return this.runtimeService;
    }

    public void setRuntimeService(RuntimeService runtimeService) {
        this.runtimeService = runtimeService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    public void setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
    }

    public void setHistoricDataService(HistoryService historicService) {
        this.setHistoryService(historicService);
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public ManagementService getManagementService() {
        return this.managementService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public CaseService getCaseService() {
        return this.caseService;
    }

    public void setCaseService(CaseService caseService) {
        this.caseService = caseService;
    }

    public FormService getFormService() {
        return this.formService;
    }

    public void setFormService(FormService formService) {
        this.formService = formService;
    }

    public void setManagementService(ManagementService managementService) {
        this.managementService = managementService;
    }

    public FilterService getFilterService() {
        return this.filterService;
    }

    public void setFilterService(FilterService filterService) {
        this.filterService = filterService;
    }

    public ExternalTaskService getExternalTaskService() {
        return this.externalTaskService;
    }

    public void setExternalTaskService(ExternalTaskService externalTaskService) {
        this.externalTaskService = externalTaskService;
    }

    public DecisionService getDecisionService() {
        return this.decisionService;
    }

    public void setDecisionService(DecisionService decisionService) {
        this.decisionService = decisionService;
    }

    public void manageDeployment(org.operaton.bpm.engine.repository.Deployment deployment) {
        this.additionalDeployments.add(deployment.getId());
    }
}

