/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.spring;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.operaton.bpm.engine.delegate.VariableScope;
import org.operaton.bpm.engine.impl.scripting.engine.Resolver;
import org.operaton.bpm.engine.impl.scripting.engine.ResolverFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.ApplicationContext;

public class SpringBeansResolverFactory
implements ResolverFactory,
Resolver {
    protected static final Logger LOG = Logger.getLogger(SpringBeansResolverFactory.class.getName());
    protected static final String SCOPE_NOT_ACTIVE_EXCEPTION = "org.springframework.beans.factory.support.ScopeNotActiveException";
    private final ApplicationContext applicationContext;
    private final Set<String> keySet;

    public SpringBeansResolverFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        String[] beannames = applicationContext.getBeanDefinitionNames();
        this.keySet = new HashSet<String>(Arrays.asList(beannames));
    }

    public Resolver createResolver(VariableScope variableScope) {
        return this;
    }

    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String stringKey = (String)key;
            return this.keySet.contains(stringKey);
        }
        return false;
    }

    public Object get(Object key) {
        if (key instanceof String) {
            String stringKey = (String)key;
            try {
                return this.applicationContext.getBean(stringKey);
            }
            catch (BeanCreationException ex) {
                if (SCOPE_NOT_ACTIVE_EXCEPTION.equals(((Object)((Object)ex)).getClass().getName())) {
                    LOG.info("Bean '" + String.valueOf(key) + "' cannot be accessed since scope is not active. Instead, null is returned. Full exception message: " + ex.getMessage());
                    return null;
                }
                throw ex;
            }
        }
        return null;
    }

    public Set<String> keySet() {
        return this.keySet;
    }
}

