/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.spring;

import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.impl.ProcessEngineImpl;
import org.operaton.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.operaton.bpm.engine.impl.el.ExpressionManager;
import org.operaton.bpm.engine.spring.SpringExpressionManager;
import org.operaton.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ProcessEngineFactoryBean
implements FactoryBean<ProcessEngine>,
DisposableBean,
ApplicationContextAware {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected ApplicationContext applicationContext;
    protected ProcessEngineImpl processEngine;

    public void destroy() throws Exception {
        if (this.processEngine != null) {
            this.processEngine.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ProcessEngine getObject() throws Exception {
        if (this.processEngine == null) {
            this.initializeExpressionManager();
            this.initializeTransactionExternallyManaged();
            this.processEngine = (ProcessEngineImpl)this.processEngineConfiguration.buildProcessEngine();
        }
        return this.processEngine;
    }

    protected void initializeExpressionManager() {
        if (this.processEngineConfiguration.getExpressionManager() == null && this.applicationContext != null) {
            this.processEngineConfiguration.setExpressionManager((ExpressionManager)new SpringExpressionManager(this.applicationContext, this.processEngineConfiguration.getBeans()));
        }
    }

    protected void initializeTransactionExternallyManaged() {
        SpringProcessEngineConfiguration engineConfiguration;
        ProcessEngineConfigurationImpl processEngineConfigurationImpl = this.processEngineConfiguration;
        if (processEngineConfigurationImpl instanceof SpringProcessEngineConfiguration && (engineConfiguration = (SpringProcessEngineConfiguration)processEngineConfigurationImpl).getTransactionManager() != null) {
            this.processEngineConfiguration.setTransactionsExternallyManaged(true);
        }
    }

    public Class<ProcessEngine> getObjectType() {
        return ProcessEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return this.processEngineConfiguration;
    }

    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }
}

