/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.spin.plugin.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.operaton.bpm.engine.impl.context.Context;
import org.operaton.bpm.engine.impl.util.IoUtil;
import org.operaton.bpm.engine.impl.variable.serializer.AbstractSerializableValueSerializer;
import org.operaton.bpm.engine.impl.variable.serializer.ValueFields;
import org.operaton.bpm.engine.variable.type.SerializableValueType;
import org.operaton.spin.Spin;
import org.operaton.spin.plugin.variable.value.SpinValue;
import org.operaton.spin.plugin.variable.value.impl.SpinValueImpl;
import org.operaton.spin.spi.DataFormat;

public abstract class SpinValueSerializer
extends AbstractSerializableValueSerializer<SpinValue> {
    protected DataFormat<?> dataFormat;
    protected String name;

    protected SpinValueSerializer(SerializableValueType type, DataFormat<?> dataFormat, String name) {
        super(type, dataFormat.getName());
        this.dataFormat = dataFormat;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void writeToValueFields(SpinValue value, ValueFields valueFields, byte[] serializedValue) {
        valueFields.setByteArrayValue(serializedValue);
    }

    protected void updateTypedValue(SpinValue value, String serializedStringValue) {
        SpinValueImpl spinValue = (SpinValueImpl)value;
        spinValue.setValueSerialized(serializedStringValue);
        spinValue.setSerializationDataFormat(this.serializationDataFormat);
    }

    protected boolean canSerializeValue(Object value) {
        if (value instanceof Spin) {
            Spin wrapper = (Spin)value;
            return wrapper.getDataFormatName().equals(this.serializationDataFormat);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serializeToByteArray(Object deserializedObject) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)out, Context.getProcessEngineConfiguration().getDefaultCharset());
        BufferedWriter bufferedWriter = new BufferedWriter(outWriter);
        try {
            Spin wrapper = (Spin)deserializedObject;
            wrapper.writeToWriter((Writer)bufferedWriter);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            IoUtil.closeSilently((Closeable)out);
            IoUtil.closeSilently((Closeable)outWriter);
            IoUtil.closeSilently((Closeable)bufferedWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeFromByteArray(byte[] object, ValueFields valueFields) {
        ByteArrayInputStream bais = new ByteArrayInputStream(object);
        InputStreamReader inReader = new InputStreamReader((InputStream)bais, Context.getProcessEngineConfiguration().getDefaultCharset());
        BufferedReader bufferedReader = new BufferedReader(inReader);
        try {
            Object wrapper = this.dataFormat.getReader().readInput((Reader)bufferedReader);
            Spin spin = this.dataFormat.createWrapperInstance(wrapper);
            return spin;
        }
        finally {
            IoUtil.closeSilently((Closeable)bais);
            IoUtil.closeSilently((Closeable)inReader);
            IoUtil.closeSilently((Closeable)bufferedReader);
        }
    }

    protected boolean isSerializationTextBased() {
        return true;
    }
}

