/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.spin.plugin.impl;

import org.operaton.bpm.engine.impl.variable.serializer.ValueFields;
import org.operaton.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.operaton.spin.DataFormats;
import org.operaton.spin.json.SpinJsonNode;
import org.operaton.spin.plugin.impl.SpinValueSerializer;
import org.operaton.spin.plugin.variable.SpinValues;
import org.operaton.spin.plugin.variable.type.SpinValueType;
import org.operaton.spin.plugin.variable.value.SpinValue;
import org.operaton.spin.plugin.variable.value.impl.JsonValueImpl;
import org.operaton.spin.spi.DataFormat;

public class JsonValueSerializer
extends SpinValueSerializer {
    public JsonValueSerializer(DataFormat<SpinJsonNode> dataFormat) {
        super(SpinValueType.JSON, dataFormat, "json");
    }

    public JsonValueSerializer() {
        this((DataFormat<SpinJsonNode>)DataFormats.json());
    }

    public SpinValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return (SpinValue)SpinValues.jsonValue((SpinJsonNode)untypedValue.getValue()).create();
    }

    protected SpinValue createDeserializedValue(Object deserializedObject, String serializedStringValue, ValueFields valueFields, boolean asTransientValue) {
        SpinJsonNode value = (SpinJsonNode)deserializedObject;
        JsonValueImpl jsonValue = new JsonValueImpl(value, serializedStringValue, this.dataFormat.getName(), true);
        jsonValue.setTransient(asTransientValue);
        return jsonValue;
    }

    protected SpinValue createSerializedValue(String serializedStringValue, ValueFields valueFields, boolean asTransientValue) {
        JsonValueImpl jsonValue = new JsonValueImpl(serializedStringValue, this.serializationDataFormat);
        jsonValue.setTransient(asTransientValue);
        return jsonValue;
    }
}

