/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.engine.test.assertions.bpmn;

import java.util.Map;
import org.operaton.bpm.engine.ProcessEngine;
import org.operaton.bpm.engine.ProcessEngines;
import org.operaton.bpm.engine.test.assertions.bpmn.AbstractProcessAssert;
import org.operaton.bpm.engine.test.assertions.bpmn.BpmnAwareTests;

public abstract class AbstractAssertions {
    static ThreadLocal<ProcessEngine> processEngine = new ThreadLocal();

    protected AbstractAssertions() {
    }

    public static ProcessEngine processEngine() {
        ProcessEngine processEngine = AbstractAssertions.processEngine.get();
        if (processEngine != null) {
            return processEngine;
        }
        Map processEngines = ProcessEngines.getProcessEngines();
        if (processEngines.size() == 1) {
            processEngine = (ProcessEngine)processEngines.values().iterator().next();
            AbstractAssertions.init(processEngine);
            return processEngine;
        }
        String message = processEngines.isEmpty() ? "No ProcessEngine found to be registered with %s!".formatted(ProcessEngines.class.getSimpleName()) : "%d ProcessEngines initialized. Call %s.init(ProcessEngine processEngine) first!".formatted(processEngines.size(), BpmnAwareTests.class.getSimpleName());
        throw new IllegalStateException(message);
    }

    public static void init(ProcessEngine processEngine) {
        AbstractAssertions.processEngine.set(processEngine);
        AbstractProcessAssert.resetLastAsserts();
    }

    public static void reset() {
        processEngine.remove();
        AbstractProcessAssert.resetLastAsserts();
    }
}

