/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.type.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.operaton.bpm.model.xml.ModelException;
import org.operaton.bpm.model.xml.impl.instance.ModelElementInstanceImpl;
import org.operaton.bpm.model.xml.impl.type.reference.ElementReferenceCollectionImpl;
import org.operaton.bpm.model.xml.impl.util.StringUtil;
import org.operaton.bpm.model.xml.instance.DomDocument;
import org.operaton.bpm.model.xml.instance.DomElement;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.child.ChildElementCollection;

public class IdsElementReferenceCollectionImpl<TARGET extends ModelElementInstance, SOURCE extends ModelElementInstance>
extends ElementReferenceCollectionImpl<TARGET, SOURCE> {
    protected String separator = " ";

    public IdsElementReferenceCollectionImpl(ChildElementCollection<SOURCE> referenceSourceCollection) {
        super(referenceSourceCollection);
    }

    protected List<String> getReferenceIdentifiers(ModelElementInstance referenceSourceElement) {
        String referenceIdentifiers = this.getReferenceIdentifier(referenceSourceElement);
        return StringUtil.splitListBySeparator(referenceIdentifiers, this.separator);
    }

    protected void setReferenceIdentifiers(ModelElementInstance referenceSourceElement, List<String> referenceIdentifiers) {
        String referenceIdentifier = StringUtil.joinList(referenceIdentifiers, this.separator);
        referenceSourceElement.setTextContent(referenceIdentifier);
    }

    @Override
    protected Collection<DomElement> getView(ModelElementInstanceImpl referenceSourceParentElement) {
        DomDocument document = referenceSourceParentElement.getModelInstance().getDocument();
        Collection referenceSourceElements = this.getReferenceSourceCollection().get(referenceSourceParentElement);
        ArrayList<DomElement> referenceTargetElements = new ArrayList<DomElement>();
        for (ModelElementInstance referenceSourceElement : referenceSourceElements) {
            List<String> identifiers = this.getReferenceIdentifiers(referenceSourceElement);
            for (String identifier : identifiers) {
                DomElement referenceTargetElement = document.getElementById(identifier);
                if (referenceTargetElement != null) {
                    referenceTargetElements.add(referenceTargetElement);
                    continue;
                }
                throw new ModelException("Unable to find a model element instance for id " + identifier);
            }
        }
        return referenceTargetElements;
    }

    @Override
    protected void updateReference(ModelElementInstance referenceSourceElement, String oldIdentifier, String newIdentifier) {
        List<String> referenceIdentifiers = this.getReferenceIdentifiers(referenceSourceElement);
        if (referenceIdentifiers.contains(oldIdentifier)) {
            int index = referenceIdentifiers.indexOf(oldIdentifier);
            referenceIdentifiers.remove(oldIdentifier);
            referenceIdentifiers.add(index, newIdentifier);
            this.setReferenceIdentifiers(referenceSourceElement, referenceIdentifiers);
        }
    }

    @Override
    public void referencedElementRemoved(ModelElementInstance referenceTargetElement, Object referenceIdentifier) {
        for (ModelElementInstance referenceSourceElement : this.findReferenceSourceElements(referenceTargetElement)) {
            List<String> referenceIdentifiers = this.getReferenceIdentifiers(referenceSourceElement);
            if (!referenceIdentifiers.contains(referenceIdentifier)) continue;
            if (referenceIdentifiers.size() == 1) {
                this.removeReference(referenceSourceElement, referenceTargetElement);
                continue;
            }
            referenceIdentifiers.remove(referenceIdentifier);
            this.setReferenceIdentifiers(referenceSourceElement, referenceIdentifiers);
        }
    }
}

