/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl.type;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.camunda.feel.syntaxtree.ZonedTime;
import org.operaton.bpm.dmn.engine.DmnEngineException;
import org.operaton.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformer;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class DateDataTypeTransformer
implements DmnDataTypeTransformer {
    protected String formatPattern = "yyyy-MM-dd'T'HH:mm:ss";

    @Override
    public TypedValue transform(Object value) throws IllegalArgumentException {
        if (value instanceof Date) {
            Date dateValue = (Date)value;
            return Variables.dateValue((Date)dateValue);
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            Date date = this.transformString(stringValue);
            return Variables.dateValue((Date)date);
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTimeValue = (ZonedDateTime)value;
            Instant instant = zonedDateTimeValue.toInstant();
            Date date = Date.from(instant);
            return Variables.dateValue((Date)date);
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTimeValue = (LocalDateTime)value;
            ZoneId defaultTimeZone = ZoneId.systemDefault();
            Instant instant = localDateTimeValue.atZone(defaultTimeZone).toInstant();
            Date date = Date.from(instant);
            return Variables.dateValue((Date)date);
        }
        if (value instanceof LocalDate) {
            throw this.unsupportedType(value);
        }
        if (value instanceof LocalTime) {
            throw this.unsupportedType(value);
        }
        if (value instanceof Duration) {
            throw this.unsupportedType(value);
        }
        if (value instanceof Period) {
            throw this.unsupportedType(value);
        }
        if (value instanceof ZonedTime) {
            throw this.unsupportedType(value);
        }
        throw new IllegalArgumentException();
    }

    protected Date transformString(String value) {
        try {
            return new SimpleDateFormat(this.formatPattern).parse(value);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected DmnEngineException unsupportedType(Object value) {
        String className = value.getClass().getName();
        return new DmnEngineException("Unsupported type: '" + className + "' cannot be converted to 'java.util.Date'");
    }
}

