/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl.hitpolicy;

import java.util.HashMap;
import java.util.Map;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.AnyHitPolicyHandler;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.CollectCountHitPolicyHandler;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.CollectHitPolicyHandler;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.CollectMaxHitPolicyHandler;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.CollectMinHitPolicyHandler;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.CollectSumHitPolicyHandler;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.FirstHitPolicyHandler;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.HitPolicyEntry;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.RuleOrderHitPolicyHandler;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.UniqueHitPolicyHandler;
import org.operaton.bpm.dmn.engine.impl.spi.hitpolicy.DmnHitPolicyHandler;
import org.operaton.bpm.dmn.engine.impl.spi.hitpolicy.DmnHitPolicyHandlerRegistry;
import org.operaton.bpm.model.dmn.BuiltinAggregator;
import org.operaton.bpm.model.dmn.HitPolicy;

public class DefaultHitPolicyHandlerRegistry
implements DmnHitPolicyHandlerRegistry {
    protected static final Map<HitPolicyEntry, DmnHitPolicyHandler> handlers = DefaultHitPolicyHandlerRegistry.getDefaultHandlers();

    protected static Map<HitPolicyEntry, DmnHitPolicyHandler> getDefaultHandlers() {
        HashMap<HitPolicyEntry, DmnHitPolicyHandler> handlers = new HashMap<HitPolicyEntry, DmnHitPolicyHandler>();
        handlers.put(new HitPolicyEntry(HitPolicy.UNIQUE, null), new UniqueHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.FIRST, null), new FirstHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.ANY, null), new AnyHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.RULE_ORDER, null), new RuleOrderHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.COLLECT, null), new CollectHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.COLLECT, BuiltinAggregator.COUNT), new CollectCountHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.COLLECT, BuiltinAggregator.SUM), new CollectSumHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.COLLECT, BuiltinAggregator.MIN), new CollectMinHitPolicyHandler());
        handlers.put(new HitPolicyEntry(HitPolicy.COLLECT, BuiltinAggregator.MAX), new CollectMaxHitPolicyHandler());
        return handlers;
    }

    @Override
    public DmnHitPolicyHandler getHandler(HitPolicy hitPolicy, BuiltinAggregator builtinAggregator) {
        return handlers.get(new HitPolicyEntry(hitPolicy, builtinAggregator));
    }

    @Override
    public void addHandler(HitPolicy hitPolicy, BuiltinAggregator builtinAggregator, DmnHitPolicyHandler hitPolicyHandler) {
        handlers.put(new HitPolicyEntry(hitPolicy, builtinAggregator), hitPolicyHandler);
    }
}

