/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl.evaluation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.dmn.engine.DmnDecision;
import org.operaton.bpm.dmn.engine.DmnDecisionResult;
import org.operaton.bpm.dmn.engine.DmnDecisionResultEntries;
import org.operaton.bpm.dmn.engine.delegate.DmnDecisionLogicEvaluationEvent;
import org.operaton.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationEvent;
import org.operaton.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationListener;
import org.operaton.bpm.dmn.engine.delegate.DmnEvaluatedDecisionRule;
import org.operaton.bpm.dmn.engine.delegate.DmnEvaluatedInput;
import org.operaton.bpm.dmn.engine.delegate.DmnEvaluatedOutput;
import org.operaton.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionResultEntriesImpl;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionResultImpl;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionTableImpl;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionTableInputImpl;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionTableOutputImpl;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionTableRuleImpl;
import org.operaton.bpm.dmn.engine.impl.DmnExpressionImpl;
import org.operaton.bpm.dmn.engine.impl.delegate.DmnDecisionTableEvaluationEventImpl;
import org.operaton.bpm.dmn.engine.impl.delegate.DmnEvaluatedDecisionRuleImpl;
import org.operaton.bpm.dmn.engine.impl.delegate.DmnEvaluatedInputImpl;
import org.operaton.bpm.dmn.engine.impl.delegate.DmnEvaluatedOutputImpl;
import org.operaton.bpm.dmn.engine.impl.evaluation.DmnDecisionLogicEvaluationHandler;
import org.operaton.bpm.dmn.engine.impl.evaluation.ExpressionEvaluationHandler;
import org.operaton.bpm.dmn.feel.impl.FeelEngine;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.context.VariableContext;
import org.operaton.bpm.engine.variable.impl.context.CompositeVariableContext;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class DecisionTableEvaluationHandler
implements DmnDecisionLogicEvaluationHandler {
    protected final ExpressionEvaluationHandler expressionEvaluationHandler;
    protected final FeelEngine feelEngine;
    protected final List<DmnDecisionTableEvaluationListener> evaluationListeners;
    protected final String inputExpressionExpressionLanguage;
    protected final String inputEntryExpressionLanguage;
    protected final String outputEntryExpressionLanguage;
    protected final boolean returnBlankTableOutputAsNull;

    public DecisionTableEvaluationHandler(DefaultDmnEngineConfiguration configuration) {
        this.expressionEvaluationHandler = new ExpressionEvaluationHandler(configuration);
        this.feelEngine = configuration.getFeelEngine();
        this.evaluationListeners = configuration.getDecisionTableEvaluationListeners();
        this.inputExpressionExpressionLanguage = configuration.getDefaultInputExpressionExpressionLanguage();
        this.inputEntryExpressionLanguage = configuration.getDefaultInputEntryExpressionLanguage();
        this.outputEntryExpressionLanguage = configuration.getDefaultOutputEntryExpressionLanguage();
        this.returnBlankTableOutputAsNull = configuration.isReturnBlankTableOutputAsNull();
    }

    @Override
    public DmnDecisionLogicEvaluationEvent evaluate(DmnDecision decision, VariableContext variableContext) {
        DmnDecisionTableEvaluationEventImpl evaluationResult = new DmnDecisionTableEvaluationEventImpl();
        evaluationResult.setDecisionTable(decision);
        DmnDecisionTableImpl decisionTable = (DmnDecisionTableImpl)decision.getDecisionLogic();
        evaluationResult.setExecutedDecisionElements(this.calculateExecutedDecisionElements(decisionTable));
        this.evaluateDecisionTable(decisionTable, variableContext, evaluationResult);
        decisionTable.getHitPolicyHandler().apply(evaluationResult);
        for (DmnDecisionTableEvaluationListener evaluationListener : this.evaluationListeners) {
            evaluationListener.notify(evaluationResult);
        }
        return evaluationResult;
    }

    protected long calculateExecutedDecisionElements(DmnDecisionTableImpl decisionTable) {
        return (long)(decisionTable.getInputs().size() + decisionTable.getOutputs().size()) * (long)decisionTable.getRules().size();
    }

    protected void evaluateDecisionTable(DmnDecisionTableImpl decisionTable, VariableContext variableContext, DmnDecisionTableEvaluationEventImpl evaluationResult) {
        int inputSize = decisionTable.getInputs().size();
        List<DmnDecisionTableRuleImpl> matchingRules = new ArrayList<DmnDecisionTableRuleImpl>(decisionTable.getRules());
        for (int inputIdx = 0; inputIdx < inputSize; ++inputIdx) {
            DmnDecisionTableInputImpl input = decisionTable.getInputs().get(inputIdx);
            DmnEvaluatedInput evaluatedInput = this.evaluateInput(input, variableContext);
            evaluationResult.getInputs().add(evaluatedInput);
            VariableContext localVariableContext = this.getLocalVariableContext(input, evaluatedInput, variableContext);
            matchingRules = this.evaluateInputForAvailableRules(inputIdx, input, matchingRules, localVariableContext);
        }
        this.setEvaluationOutput(decisionTable, matchingRules, variableContext, evaluationResult);
    }

    protected DmnEvaluatedInput evaluateInput(DmnDecisionTableInputImpl input, VariableContext variableContext) {
        DmnEvaluatedInputImpl evaluatedInput = new DmnEvaluatedInputImpl(input);
        DmnExpressionImpl expression = input.getExpression();
        if (expression != null) {
            Object value = this.evaluateInputExpression(expression, variableContext);
            TypedValue typedValue = expression.getTypeDefinition().transform(value);
            evaluatedInput.setValue(typedValue);
        } else {
            evaluatedInput.setValue(Variables.untypedNullValue());
        }
        return evaluatedInput;
    }

    protected List<DmnDecisionTableRuleImpl> evaluateInputForAvailableRules(int conditionIdx, DmnDecisionTableInputImpl input, List<DmnDecisionTableRuleImpl> availableRules, VariableContext variableContext) {
        ArrayList<DmnDecisionTableRuleImpl> matchingRules = new ArrayList<DmnDecisionTableRuleImpl>();
        for (DmnDecisionTableRuleImpl availableRule : availableRules) {
            DmnExpressionImpl condition = availableRule.getConditions().get(conditionIdx);
            if (!this.isConditionApplicable(input, condition, variableContext)) continue;
            matchingRules.add(availableRule);
        }
        return matchingRules;
    }

    protected boolean isConditionApplicable(DmnDecisionTableInputImpl input, DmnExpressionImpl condition, VariableContext variableContext) {
        Object result = this.evaluateInputEntry(input, condition, variableContext);
        return result != null && result.equals(true);
    }

    protected void setEvaluationOutput(DmnDecisionTableImpl decisionTable, List<DmnDecisionTableRuleImpl> matchingRules, VariableContext variableContext, DmnDecisionTableEvaluationEventImpl evaluationResult) {
        List<DmnDecisionTableOutputImpl> decisionTableOutputs = decisionTable.getOutputs();
        ArrayList<DmnEvaluatedDecisionRule> evaluatedDecisionRules = new ArrayList<DmnEvaluatedDecisionRule>();
        for (DmnDecisionTableRuleImpl matchingRule : matchingRules) {
            DmnEvaluatedDecisionRule evaluatedRule = this.evaluateMatchingRule(decisionTableOutputs, matchingRule, variableContext);
            evaluatedDecisionRules.add(evaluatedRule);
        }
        evaluationResult.setMatchingRules(evaluatedDecisionRules);
    }

    protected DmnEvaluatedDecisionRule evaluateMatchingRule(List<DmnDecisionTableOutputImpl> decisionTableOutputs, DmnDecisionTableRuleImpl matchingRule, VariableContext variableContext) {
        DmnEvaluatedDecisionRuleImpl evaluatedDecisionRule = new DmnEvaluatedDecisionRuleImpl(matchingRule);
        Map<String, DmnEvaluatedOutput> outputEntries = this.evaluateOutputEntries(decisionTableOutputs, matchingRule, variableContext);
        evaluatedDecisionRule.setOutputEntries(outputEntries);
        return evaluatedDecisionRule;
    }

    protected VariableContext getLocalVariableContext(DmnDecisionTableInputImpl input, DmnEvaluatedInput evaluatedInput, VariableContext variableContext) {
        if (this.isNonEmptyExpression(input.getExpression())) {
            String inputVariableName = evaluatedInput.getInputVariable();
            return CompositeVariableContext.compose((VariableContext[])new VariableContext[]{Variables.createVariables().putValue("inputVariableName", (Object)inputVariableName).putValueTyped(inputVariableName, evaluatedInput.getValue()).asVariableContext(), variableContext});
        }
        return variableContext;
    }

    protected boolean isNonEmptyExpression(DmnExpressionImpl expression) {
        return expression != null && expression.getExpression() != null && !expression.getExpression().trim().isEmpty();
    }

    protected Object evaluateInputExpression(DmnExpressionImpl expression, VariableContext variableContext) {
        String expressionLanguage = expression.getExpressionLanguage();
        if (expressionLanguage == null) {
            expressionLanguage = this.inputExpressionExpressionLanguage;
        }
        return this.expressionEvaluationHandler.evaluateExpression(expressionLanguage, expression, variableContext);
    }

    protected Object evaluateInputEntry(DmnDecisionTableInputImpl input, DmnExpressionImpl condition, VariableContext variableContext) {
        if (this.isNonEmptyExpression(condition)) {
            String expressionLanguage = condition.getExpressionLanguage();
            if (expressionLanguage == null) {
                expressionLanguage = this.inputEntryExpressionLanguage;
            }
            if (this.expressionEvaluationHandler.isFeelExpressionLanguage(expressionLanguage)) {
                return this.evaluateFeelSimpleUnaryTests(input, condition, variableContext);
            }
            return this.expressionEvaluationHandler.evaluateExpression(expressionLanguage, condition, variableContext);
        }
        return true;
    }

    protected Map<String, DmnEvaluatedOutput> evaluateOutputEntries(List<DmnDecisionTableOutputImpl> decisionTableOutputs, DmnDecisionTableRuleImpl matchingRule, VariableContext variableContext) {
        LinkedHashMap<String, DmnEvaluatedOutput> outputEntries = new LinkedHashMap<String, DmnEvaluatedOutput>();
        for (int outputIdx = 0; outputIdx < decisionTableOutputs.size(); ++outputIdx) {
            DmnExpressionImpl conclusion = matchingRule.getConclusions().get(outputIdx);
            boolean isNonEmptyExpression = this.isNonEmptyExpression(conclusion);
            if (!this.returnBlankTableOutputAsNull && !isNonEmptyExpression) continue;
            DmnDecisionTableOutputImpl decisionTableOutput = decisionTableOutputs.get(outputIdx);
            Object value = isNonEmptyExpression ? this.evaluateOutputEntry(conclusion, variableContext) : null;
            TypedValue typedValue = decisionTableOutput.getTypeDefinition().transform(value);
            DmnEvaluatedOutputImpl evaluatedOutput = new DmnEvaluatedOutputImpl(decisionTableOutput, typedValue);
            outputEntries.put(decisionTableOutput.getOutputName(), evaluatedOutput);
        }
        return outputEntries;
    }

    protected Object evaluateOutputEntry(DmnExpressionImpl conclusion, VariableContext variableContext) {
        String expressionLanguage = conclusion.getExpressionLanguage();
        if (expressionLanguage == null) {
            expressionLanguage = this.outputEntryExpressionLanguage;
        }
        return this.expressionEvaluationHandler.evaluateExpression(expressionLanguage, conclusion, variableContext);
    }

    protected Object evaluateFeelSimpleUnaryTests(DmnDecisionTableInputImpl input, DmnExpressionImpl condition, VariableContext variableContext) {
        String expressionText = condition.getExpression();
        if (expressionText != null) {
            return this.feelEngine.evaluateSimpleUnaryTests(expressionText, input.getInputVariable(), variableContext);
        }
        return null;
    }

    @Override
    public DmnDecisionResult generateDecisionResult(DmnDecisionLogicEvaluationEvent event) {
        DmnDecisionTableEvaluationEvent evaluationResult = (DmnDecisionTableEvaluationEvent)event;
        ArrayList<DmnDecisionResultEntries> ruleResults = new ArrayList<DmnDecisionResultEntries>();
        if (evaluationResult.getCollectResultName() != null || evaluationResult.getCollectResultValue() != null) {
            DmnDecisionResultEntriesImpl ruleResult = new DmnDecisionResultEntriesImpl();
            ruleResult.putValue(evaluationResult.getCollectResultName(), evaluationResult.getCollectResultValue());
            ruleResults.add(ruleResult);
        } else {
            for (DmnEvaluatedDecisionRule evaluatedRule : evaluationResult.getMatchingRules()) {
                DmnDecisionResultEntriesImpl ruleResult = new DmnDecisionResultEntriesImpl();
                for (DmnEvaluatedOutput evaluatedOutput : evaluatedRule.getOutputEntries().values()) {
                    ruleResult.putValue(evaluatedOutput.getOutputName(), evaluatedOutput.getValue());
                }
                ruleResults.add(ruleResult);
            }
        }
        return new DmnDecisionResultImpl(ruleResults);
    }
}

