/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.revwalk;

import java.io.IOException;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.revwalk.FIFORevQueue;
import org.openrewrite.jgit.revwalk.Generator;
import org.openrewrite.jgit.revwalk.RevCommit;

final class DelayRevQueue
extends Generator {
    private static final int OVER_SCAN = 6;
    private final Generator pending;
    private final FIFORevQueue delay;
    private int size;

    DelayRevQueue(Generator g) {
        super(g.firstParent);
        this.pending = g;
        this.delay = new FIFORevQueue();
    }

    @Override
    int outputType() {
        return this.pending.outputType();
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        while (this.size < 6 && (c = this.pending.next()) != null) {
            this.delay.add(c);
            ++this.size;
        }
        c = this.delay.next();
        if (c == null) {
            return null;
        }
        --this.size;
        return c;
    }
}

