/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.revwalk;

import java.io.IOException;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.revwalk.BlockRevQueue;
import org.openrewrite.jgit.revwalk.FIFORevQueue;
import org.openrewrite.jgit.revwalk.Generator;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevWalk;

class BoundaryGenerator
extends Generator {
    static final int UNINTERESTING = 4;
    Generator g;

    BoundaryGenerator(RevWalk w, Generator s) {
        super(s.firstParent);
        this.g = new InitialGenerator(w, s);
    }

    @Override
    int outputType() {
        return this.g.outputType() | 0x10;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        this.g.shareFreeList(q);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.g.next();
    }

    private class InitialGenerator
    extends Generator {
        private static final int PARSED = 1;
        private static final int DUPLICATE = 16;
        private final RevWalk walk;
        private final FIFORevQueue held;
        private final Generator source;

        InitialGenerator(RevWalk w, Generator s) {
            super(s.firstParent);
            this.walk = w;
            this.held = new FIFORevQueue(this.firstParent);
            this.source = s;
            this.source.shareFreeList(this.held);
        }

        @Override
        int outputType() {
            return this.source.outputType();
        }

        @Override
        void shareFreeList(BlockRevQueue q) {
            q.shareFreeList(this.held);
        }

        @Override
        RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
            RevCommit c = this.source.next();
            if (c != null) {
                for (int i = 0; !(i >= c.parents.length || this.firstParent && i > 0); ++i) {
                    RevCommit p = c.parents[i];
                    if ((p.flags & 4) == 0) continue;
                    this.held.add(p);
                }
                return c;
            }
            FIFORevQueue boundary = new FIFORevQueue(this.firstParent);
            boundary.shareFreeList(this.held);
            while ((c = this.held.next()) != null) {
                if ((c.flags & 0x10) != 0) continue;
                if ((c.flags & 1) == 0) {
                    c.parseHeaders(this.walk);
                }
                c.flags |= 0x10;
                boundary.add(c);
            }
            boundary.removeFlag(16);
            BoundaryGenerator.this.g = boundary;
            return boundary.next();
        }
    }
}

