/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.internal.transport.connectivity;

import java.io.IOException;
import java.util.Set;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectIdSubclassMap;
import org.openrewrite.jgit.lib.ProgressMonitor;
import org.openrewrite.jgit.revwalk.ObjectWalk;
import org.openrewrite.jgit.revwalk.RevBlob;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevFlag;
import org.openrewrite.jgit.revwalk.RevObject;
import org.openrewrite.jgit.revwalk.RevSort;
import org.openrewrite.jgit.revwalk.RevTree;
import org.openrewrite.jgit.transport.ConnectivityChecker;
import org.openrewrite.jgit.transport.ReceiveCommand;

public final class FullConnectivityChecker
implements ConnectivityChecker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConnectivity(ConnectivityChecker.ConnectivityCheckInfo connectivityCheckInfo, Set<ObjectId> haves, ProgressMonitor pm) throws MissingObjectException, IOException {
        pm.beginTask(JGitText.get().countingObjects, 0);
        try (ObjectWalk ow = new ObjectWalk(connectivityCheckInfo.getRepository());){
            if (!this.markStartAndKnownNodes(connectivityCheckInfo, ow, haves, pm)) {
                return;
            }
            this.checkCommitTree(connectivityCheckInfo, ow, pm);
            this.checkObjects(connectivityCheckInfo, ow, pm);
        }
        finally {
            pm.endTask();
        }
    }

    private boolean markStartAndKnownNodes(ConnectivityChecker.ConnectivityCheckInfo connectivityCheckInfo, ObjectWalk ow, Set<ObjectId> haves, ProgressMonitor pm) throws IOException {
        boolean markTrees;
        boolean bl = markTrees = connectivityCheckInfo.isCheckObjects() && !connectivityCheckInfo.getParser().getBaseObjectIds().isEmpty();
        if (connectivityCheckInfo.isCheckObjects()) {
            ow.sort(RevSort.TOPO);
            if (!connectivityCheckInfo.getParser().getBaseObjectIds().isEmpty()) {
                ow.sort(RevSort.BOUNDARY, true);
            }
        }
        boolean hasInteresting = false;
        for (ReceiveCommand cmd : connectivityCheckInfo.getCommands()) {
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED || cmd.getType() == ReceiveCommand.Type.DELETE || haves.contains(cmd.getNewId())) continue;
            ow.markStart(ow.parseAny(cmd.getNewId()));
            pm.update(1);
            hasInteresting = true;
        }
        if (!hasInteresting) {
            return false;
        }
        for (ObjectId have : haves) {
            RevObject o = ow.parseAny(have);
            ow.markUninteresting(o);
            pm.update(1);
            if (!markTrees) continue;
            if ((o = ow.peel(o)) instanceof RevCommit) {
                o = ((RevCommit)o).getTree();
            }
            if (!(o instanceof RevTree)) continue;
            ow.markUninteresting(o);
        }
        return true;
    }

    private void checkCommitTree(ConnectivityChecker.ConnectivityCheckInfo connectivityCheckInfo, ObjectWalk ow, ProgressMonitor pm) throws IOException {
        RevCommit c;
        ObjectIdSubclassMap<ObjectId> newObjectIds = connectivityCheckInfo.getParser().getNewObjectIds();
        while ((c = ow.next()) != null) {
            pm.update(1);
            if (!connectivityCheckInfo.isCheckObjects() || c.has(RevFlag.UNINTERESTING) || newObjectIds.contains(c)) continue;
            throw new MissingObjectException((ObjectId)c, "commit");
        }
    }

    private void checkObjects(ConnectivityChecker.ConnectivityCheckInfo connectivityCheckInfo, ObjectWalk ow, ProgressMonitor pm) throws IOException {
        RevObject o;
        ObjectIdSubclassMap<ObjectId> newObjectIds = connectivityCheckInfo.getParser().getNewObjectIds();
        while ((o = ow.nextObject()) != null) {
            pm.update(1);
            if (o.has(RevFlag.UNINTERESTING)) continue;
            if (connectivityCheckInfo.isCheckObjects()) {
                if (newObjectIds.contains(o)) continue;
                throw new MissingObjectException((ObjectId)o, o.getType());
            }
            if (!(o instanceof RevBlob) || connectivityCheckInfo.getRepository().getObjectDatabase().has(o)) continue;
            throw new MissingObjectException((ObjectId)o, "blob");
        }
        if (connectivityCheckInfo.isCheckObjects()) {
            for (ObjectId id : connectivityCheckInfo.getParser().getBaseObjectIds()) {
                o = ow.parseAny(id);
                if (o.has(RevFlag.UNINTERESTING)) continue;
                throw new MissingObjectException((ObjectId)o, o.getType());
            }
        }
    }
}

