/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class DeleteKey
extends Recipe {
    @Option(displayName="Key path", description="A [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expression to locate a YAML entry.", example="$.source.kind")
    private final String keyPath;
    @Option(displayName="File pattern", description="A glob expression representing a file path to search for (relative to the project root). Blank/null matches all.", required=false, example=".github/workflows/*.yml")
    private final @Nullable String filePattern;
    private final String displayName = "Delete key";
    private final String description = "Delete a YAML mapping entry key.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.keyPath);
        return Preconditions.check((Recipe)new FindSourceFiles(this.filePattern), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public @Nullable Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, ExecutionContext ctx) {
                if (matcher.matches(this.getCursor()) || matcher.matches(new Cursor(this.getCursor(), (Object)entry.getBlock()))) {
                    this.removeUnused(this.getCursor().getParent());
                    return null;
                }
                return super.visitSequenceEntry(entry, ctx);
            }

            @Override
            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                Yaml m = super.visitMapping(mapping, ctx);
                AtomicReference copyFirstPrefix = new AtomicReference();
                if (!((Yaml.Mapping)(m = ((Yaml.Mapping)m).withEntries(ListUtils.map(((Yaml.Mapping)m).getEntries(), (i, e) -> {
                    if (matcher.matches(new Cursor(this.getCursor(), e))) {
                        if (i == 0 && this.getCursor().getParentOrThrow().getValue() instanceof Yaml.Sequence.Entry) {
                            copyFirstPrefix.set(e.getPrefix());
                        }
                        this.removeUnused(this.getCursor().getParent());
                        return null;
                    }
                    return e;
                })))).getEntries().isEmpty() && copyFirstPrefix.get() != null) {
                    m = ((Yaml.Mapping)m).withEntries(ListUtils.mapFirst(((Yaml.Mapping)m).getEntries(), e -> e.withPrefix((String)copyFirstPrefix.get())));
                }
                return m;
            }
        });
    }

    @Generated
    public DeleteKey(String keyPath, @Nullable String filePattern) {
        this.keyPath = keyPath;
        this.filePattern = filePattern;
    }

    @Generated
    public String getKeyPath() {
        return this.keyPath;
    }

    @Generated
    public @Nullable String getFilePattern() {
        return this.filePattern;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DeleteKey(keyPath=" + this.getKeyPath() + ", filePattern=" + this.getFilePattern() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteKey)) {
            return false;
        }
        DeleteKey other = (DeleteKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        if (this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DeleteKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

