/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.yaml.CoalescePropertiesVisitor;

public final class CoalesceProperties
extends Recipe {
    @Option(displayName="Exclusions", description="An optional list of [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expressions to specify keys that should not be unfolded.", example="$..[org.springframework.security]", required=false)
    private final @Nullable List<String> exclusions;
    @Option(displayName="Apply to", description="An optional list of [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expressions that specify which keys the recipe should target only. Only the properties matching these expressions will be unfolded.", example="$..[org.springframework.security]", required=false)
    private final @Nullable List<String> applyTo;
    private final String displayName = "Coalesce YAML properties";
    private final String description = "Simplify nested map hierarchies into their simplest dot separated property form, similar to how Spring Boot interprets `application.yml` files.";

    @Deprecated
    public CoalesceProperties() {
        this(null, null);
    }

    @JsonCreator
    public CoalesceProperties(@Nullable List<String> exclusions, @Nullable List<String> applyTo) {
        this.exclusions = exclusions == null ? Collections.emptyList() : exclusions;
        this.applyTo = applyTo == null ? Collections.emptyList() : applyTo;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CoalescePropertiesVisitor<ExecutionContext>(this.exclusions, this.applyTo);
    }

    @Generated
    public @Nullable List<String> getExclusions() {
        return this.exclusions;
    }

    @Generated
    public @Nullable List<String> getApplyTo() {
        return this.applyTo;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "CoalesceProperties(exclusions=" + this.getExclusions() + ", applyTo=" + this.getApplyTo() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoalesceProperties)) {
            return false;
        }
        CoalesceProperties other = (CoalesceProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<String> this$exclusions = this.getExclusions();
        List<String> other$exclusions = other.getExclusions();
        if (this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions)) {
            return false;
        }
        List<String> this$applyTo = this.getApplyTo();
        List<String> other$applyTo = other.getApplyTo();
        if (this$applyTo == null ? other$applyTo != null : !((Object)this$applyTo).equals(other$applyTo)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof CoalesceProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $exclusions = this.getExclusions();
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        List<String> $applyTo = this.getApplyTo();
        result = result * 59 + ($applyTo == null ? 43 : ((Object)$applyTo).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

