/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.search;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.search.HasNamespaceUri;

public final class DoesNotUseNamespaceUri
extends Recipe {
    @Option(displayName="Namespace URI", description="The Namespace URI to check.", example="http://www.w3.org/2001/XMLSchema-instance")
    private final String namespaceUri;
    private final String displayName = "Find files without Namespace URI";
    private final String description = "Find XML root elements that do not have a specific Namespace URI, optionally restricting the search by an XPath expression.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.not(new HasNamespaceUri(this.namespaceUri, null).getVisitor());
    }

    @Generated
    public DoesNotUseNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    @Generated
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DoesNotUseNamespaceUri(namespaceUri=" + this.getNamespaceUri() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoesNotUseNamespaceUri)) {
            return false;
        }
        DoesNotUseNamespaceUri other = (DoesNotUseNamespaceUri)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$namespaceUri = this.getNamespaceUri();
        String other$namespaceUri = other.getNamespaceUri();
        if (this$namespaceUri == null ? other$namespaceUri != null : !this$namespaceUri.equals(other$namespaceUri)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DoesNotUseNamespaceUri;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespaceUri = this.getNamespaceUri();
        result = result * 59 + ($namespaceUri == null ? 43 : $namespaceUri.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

