/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.format;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.Style;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.format.AutodetectGeneralFormatStyle;
import org.openrewrite.xml.format.NormalizeLineBreaksVisitor;
import org.openrewrite.xml.tree.Xml;

public class NormalizeLineBreaks
extends Recipe {
    final String displayName = "Normalize line breaks";
    final String description = "Consistently use either Windows style (CRLF) or Linux style (LF) line breaks. If no `GeneralFormatStyle` is specified this will use whichever style of line endings are more common.";

    public XmlIsoVisitor<ExecutionContext> getVisitor() {
        return new LineBreaksFromCompilationUnitStyle();
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    private static class LineBreaksFromCompilationUnitStyle
    extends XmlIsoVisitor<ExecutionContext> {
        private LineBreaksFromCompilationUnitStyle() {
        }

        @Override
        public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
            GeneralFormatStyle generalFormatStyle = (GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)document, () -> AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(document));
            this.doAfterVisit(new NormalizeLineBreaksVisitor(generalFormatStyle));
            return document;
        }
    }
}

