/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.xml.XsltTransformationVisitor;

@Incubating(since="8.30.0")
public final class XsltTransformation
extends Recipe {
    @Option(displayName="XSLT Configuration transformation", description="The transformation to be applied.", example="<xsl:stylesheet ...>...</xsl:stylesheet>", required=false)
    @Language(value="xml")
    private final @Nullable String xslt;
    @Option(displayName="XSLT Configuration transformation classpath resource", description="Recipe transformation provided as a classpath resource.", example="/changePlugin.xslt", required=false)
    private final @Nullable String xsltResource;
    @Option(displayName="File pattern", description="A glob expression that can be used to constrain which directories or source files should be searched. Multiple patterns may be specified, separated by a semicolon `;`. If multiple patterns are supplied any of the patterns matching will be interpreted as a match.", example="**/*.xml")
    private final String filePattern;
    private final String displayName = "XSLT transformation";
    private final String description = "Apply the specified XSLT transformation on matching files. Note that there are no format matching guarantees when running this recipe.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        XsltTransformationVisitor visitor = new XsltTransformationVisitor(XsltTransformation.loadResource(this.xslt, this.xsltResource));
        TreeVisitor check = Preconditions.or((TreeVisitor[])((TreeVisitor[])Arrays.stream(this.filePattern.split(";")).map(FindSourceFiles::new).map(FindSourceFiles::getVisitor).toArray(TreeVisitor[]::new)));
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)visitor);
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"xslt", (String)"set either xslt or xsltResource, but not both", (Object)this.xslt, s -> StringUtils.isBlank((String)s) != StringUtils.isBlank((String)this.xsltResource) && !StringUtils.isBlank((String)XsltTransformation.loadResource(this.xslt, this.xsltResource))));
    }

    private static String loadResource(@Nullable String xslt, @Nullable String xsltResource) {
        String string;
        block10: {
            if (StringUtils.isBlank((String)xsltResource)) {
                return Objects.requireNonNull(xslt);
            }
            InputStream is = XsltTransformation.class.getResourceAsStream(xsltResource);
            try {
                assert (is != null);
                string = StringUtils.readFully((InputStream)is, (Charset)Charset.defaultCharset());
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return string;
    }

    @Generated
    public XsltTransformation(@Language(value="xml") @Nullable String xslt, @Nullable String xsltResource, String filePattern) {
        this.xslt = xslt;
        this.xsltResource = xsltResource;
        this.filePattern = filePattern;
    }

    @Language(value="xml")
    @Generated
    public @Nullable String getXslt() {
        return this.xslt;
    }

    @Generated
    public @Nullable String getXsltResource() {
        return this.xsltResource;
    }

    @Generated
    public String getFilePattern() {
        return this.filePattern;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "XsltTransformation(xslt=" + this.getXslt() + ", xsltResource=" + this.getXsltResource() + ", filePattern=" + this.getFilePattern() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XsltTransformation)) {
            return false;
        }
        XsltTransformation other = (XsltTransformation)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$xslt = this.getXslt();
        String other$xslt = other.getXslt();
        if (this$xslt == null ? other$xslt != null : !this$xslt.equals(other$xslt)) {
            return false;
        }
        String this$xsltResource = this.getXsltResource();
        String other$xsltResource = other.getXsltResource();
        if (this$xsltResource == null ? other$xsltResource != null : !this$xsltResource.equals(other$xsltResource)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        if (this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof XsltTransformation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xslt = this.getXslt();
        result = result * 59 + ($xslt == null ? 43 : $xslt.hashCode());
        String $xsltResource = this.getXsltResource();
        result = result * 59 + ($xsltResource == null ? 43 : $xsltResource.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

