/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class RemoveXmlTag
extends Recipe {
    @Option(displayName="XPath", description="An XPath expression used to find matching tags.", example="/project/dependencies/dependency")
    private final String xPath;
    @Option(displayName="File matcher", description="If provided only matching files will be modified. This is a glob expression.", required=false, example="'**/application-*.xml'")
    private final @Nullable String fileMatcher;
    private final String displayName = "Remove XML tag";
    private final String description = "Removes XML tags matching the provided expression.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(this.fileMatcher), (TreeVisitor)new XmlIsoVisitor<ExecutionContext>(){
            private final XPathMatcher xPathMatcher;
            {
                this.xPathMatcher = new XPathMatcher(RemoveXmlTag.this.xPath);
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.xPathMatcher.matches(this.getCursor())) {
                    this.doAfterVisit(new RemoveContentVisitor(tag, true, true));
                }
                return super.visitTag(tag, ctx);
            }
        });
    }

    @Generated
    public RemoveXmlTag(String xPath, @Nullable String fileMatcher) {
        this.xPath = xPath;
        this.fileMatcher = fileMatcher;
    }

    @Generated
    public String getXPath() {
        return this.xPath;
    }

    @Generated
    public @Nullable String getFileMatcher() {
        return this.fileMatcher;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveXmlTag(xPath=" + this.getXPath() + ", fileMatcher=" + this.getFileMatcher() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveXmlTag)) {
            return false;
        }
        RemoveXmlTag other = (RemoveXmlTag)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$xPath = this.getXPath();
        String other$xPath = other.getXPath();
        if (this$xPath == null ? other$xPath != null : !this$xPath.equals(other$xPath)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        if (this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveXmlTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xPath = this.getXPath();
        result = result * 59 + ($xPath == null ? 43 : $xPath.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

