/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.CreateFileVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class CreateXmlFile
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="Relative file path", description="File path of new file.", example="foo/bar/baz.xml")
    private final String relativeFileName;
    @Option(displayName="File contents", description="Multiline text content for the file.", example="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>\n    <child>1</child></root>", required=false)
    @Language(value="xml")
    private final @Nullable String fileContents;
    @Option(displayName="Overwrite existing file", description="If there is an existing file, should it be overwritten.", required=false)
    private final @Nullable Boolean overwriteExisting;
    private final String displayName = "Create XML file";
    private final String description = "Create a new XML file.";

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(true);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(AtomicBoolean shouldCreate) {
        return new CreateFileVisitor(Paths.get(this.relativeFileName, new String[0]), shouldCreate);
    }

    public Collection<SourceFile> generate(AtomicBoolean shouldCreate, ExecutionContext ctx) {
        if (shouldCreate.get()) {
            return XmlParser.builder().build().parse(this.fileContents == null ? "" : this.fileContents).map(brandNewFile -> brandNewFile.withSourcePath(Paths.get(this.relativeFileName, new String[0]))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean created) {
        final Path path = Paths.get(this.relativeFileName, new String[0]);
        return new XmlVisitor<ExecutionContext>(){

            @Override
            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                if (Boolean.TRUE.equals(CreateXmlFile.this.overwriteExisting) && path.equals(document.getSourcePath())) {
                    SourceFile sourceFile;
                    if (StringUtils.isBlank((String)CreateXmlFile.this.fileContents)) {
                        return document.withProlog(null).withRoot(null);
                    }
                    Optional<SourceFile> sourceFiles = XmlParser.builder().build().parse(CreateXmlFile.this.fileContents).findFirst();
                    if (sourceFiles.isPresent() && (sourceFile = sourceFiles.get()) instanceof Xml.Document) {
                        Xml.Document newXmlDocument = (Xml.Document)sourceFile;
                        return document.withProlog(newXmlDocument.getProlog()).withRoot(newXmlDocument.getRoot());
                    }
                }
                return document;
            }
        };
    }

    @Generated
    public CreateXmlFile(String relativeFileName, @Language(value="xml") @Nullable String fileContents, @Nullable Boolean overwriteExisting) {
        this.relativeFileName = relativeFileName;
        this.fileContents = fileContents;
        this.overwriteExisting = overwriteExisting;
    }

    @Generated
    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    @Language(value="xml")
    @Generated
    public @Nullable String getFileContents() {
        return this.fileContents;
    }

    @Generated
    public @Nullable Boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "CreateXmlFile(relativeFileName=" + this.getRelativeFileName() + ", fileContents=" + this.getFileContents() + ", overwriteExisting=" + this.getOverwriteExisting() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateXmlFile)) {
            return false;
        }
        CreateXmlFile other = (CreateXmlFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overwriteExisting = this.getOverwriteExisting();
        Boolean other$overwriteExisting = other.getOverwriteExisting();
        if (this$overwriteExisting == null ? other$overwriteExisting != null : !((Object)this$overwriteExisting).equals(other$overwriteExisting)) {
            return false;
        }
        String this$relativeFileName = this.getRelativeFileName();
        String other$relativeFileName = other.getRelativeFileName();
        if (this$relativeFileName == null ? other$relativeFileName != null : !this$relativeFileName.equals(other$relativeFileName)) {
            return false;
        }
        String this$fileContents = this.getFileContents();
        String other$fileContents = other.getFileContents();
        if (this$fileContents == null ? other$fileContents != null : !this$fileContents.equals(other$fileContents)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof CreateXmlFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overwriteExisting = this.getOverwriteExisting();
        result = result * 59 + ($overwriteExisting == null ? 43 : ((Object)$overwriteExisting).hashCode());
        String $relativeFileName = this.getRelativeFileName();
        result = result * 59 + ($relativeFileName == null ? 43 : $relativeFileName.hashCode());
        String $fileContents = this.getFileContents();
        result = result * 59 + ($fileContents == null ? 43 : $fileContents.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

