/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeTagAttributeKey
extends Recipe {
    private final String displayName = "Change XML attribute key";
    private final String description = "Change an attributes key on XML elements using an XPath expression.";
    @Option(displayName="Attribute XPath", description="XPath expression to match the attribute.", example="//a4j:ajax/@reRender")
    private final String xPath;
    @Option(displayName="New attribute name", description="The new name for the attribute.", example="render")
    private final String newAttributeName;

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final XPathMatcher xPathMatcher = new XPathMatcher(this.xPath);
        return new XmlIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Attribute visitAttribute(Xml.Attribute attribute, ExecutionContext ctx) {
                Xml a = super.visitAttribute(attribute, ctx);
                if (!xPathMatcher.matches(this.getCursor())) {
                    return a;
                }
                return ((Xml.Attribute)a).withKey(((Xml.Attribute)a).getKey().withName(ChangeTagAttributeKey.this.newAttributeName));
            }
        };
    }

    @Generated
    public ChangeTagAttributeKey(String xPath, String newAttributeName) {
        this.xPath = xPath;
        this.newAttributeName = newAttributeName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getXPath() {
        return this.xPath;
    }

    @Generated
    public String getNewAttributeName() {
        return this.newAttributeName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeTagAttributeKey(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", xPath=" + this.getXPath() + ", newAttributeName=" + this.getNewAttributeName() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTagAttributeKey)) {
            return false;
        }
        ChangeTagAttributeKey other = (ChangeTagAttributeKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$xPath = this.getXPath();
        String other$xPath = other.getXPath();
        if (this$xPath == null ? other$xPath != null : !this$xPath.equals(other$xPath)) {
            return false;
        }
        String this$newAttributeName = this.getNewAttributeName();
        String other$newAttributeName = other.getNewAttributeName();
        return !(this$newAttributeName == null ? other$newAttributeName != null : !this$newAttributeName.equals(other$newAttributeName));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeTagAttributeKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $xPath = this.getXPath();
        result = result * 59 + ($xPath == null ? 43 : $xPath.hashCode());
        String $newAttributeName = this.getNewAttributeName();
        result = result * 59 + ($newAttributeName == null ? 43 : $newAttributeName.hashCode());
        return result;
    }
}

