/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.toml.TomlIsoVisitor;
import org.openrewrite.toml.TomlPathMatcher;
import org.openrewrite.toml.tree.Toml;

public final class FindKey
extends Recipe {
    @Option(displayName="Key path", description="A TOML path expression to locate keys. Wildcards are supported.", example="**.name")
    private final String keyPath;
    private final String displayName = "Find TOML keys";
    private final String description = "Find TOML keys matching a path expression.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TomlPathMatcher matcher = new TomlPathMatcher(this.keyPath);
        return new TomlIsoVisitor<ExecutionContext>(){

            @Override
            public Toml.KeyValue visitKeyValue(Toml.KeyValue keyValue, ExecutionContext ctx) {
                Toml kv = super.visitKeyValue(keyValue, ctx);
                return matcher.matches(this.getCursor()) ? (Toml.KeyValue)SearchResult.found((Tree)kv) : kv;
            }
        };
    }

    @Generated
    public FindKey(String keyPath) {
        this.keyPath = keyPath;
    }

    @Generated
    public String getKeyPath() {
        return this.keyPath;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindKey(keyPath=" + this.getKeyPath() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindKey)) {
            return false;
        }
        FindKey other = (FindKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

