/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.toml;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.CreateFileVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.remote.Remote;
import org.openrewrite.toml.TomlParser;
import org.openrewrite.toml.TomlVisitor;
import org.openrewrite.toml.tree.Toml;

public final class CreateTomlFile
extends ScanningRecipe<AtomicBoolean> {
    @Option(displayName="Relative file path", description="File path of the new file.", example="pyproject.toml")
    private final String relativeFileName;
    @Option(displayName="File contents", description="Multiline text content for the file.", example="[tool.poetry]\nname = \"my-project\"\nversion = \"0.1.0\"", required=false)
    @Language(value="toml")
    private final @Nullable String fileContents;
    @Option(displayName="File contents URL", description="URL to fetch the TOML file contents from a remote source.", example="https://raw.githubusercontent.com/example/repo/main/pyproject.toml", required=false)
    private final @Nullable String fileContentsUrl;
    @Option(displayName="Overwrite existing file", description="If there is an existing file, should it be overwritten?", required=false)
    private final @Nullable Boolean overwriteExisting;
    private final String displayName = "Create TOML file";
    private final String description = "Create a new TOML file.";

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(true);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(AtomicBoolean shouldCreate) {
        return new CreateFileVisitor(Paths.get(this.relativeFileName, new String[0]), shouldCreate);
    }

    public Collection<SourceFile> generate(AtomicBoolean shouldCreate, ExecutionContext ctx) {
        if (shouldCreate.get()) {
            String tomlContents = this.getTomlContents(ctx);
            if (StringUtils.isBlank((String)tomlContents)) {
                return Collections.emptyList();
            }
            return TomlParser.builder().build().parse(tomlContents).map(brandNewFile -> brandNewFile.withSourcePath(Paths.get(this.relativeFileName, new String[0]))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean created) {
        final Path path = Paths.get(this.relativeFileName, new String[0]);
        return new TomlVisitor<ExecutionContext>(){

            public Toml.Document visitDocument(Toml.Document document, ExecutionContext ctx) {
                if (Boolean.TRUE.equals(CreateTomlFile.this.overwriteExisting) && path.equals(document.getSourcePath())) {
                    SourceFile sourceFile;
                    String tomlContents = CreateTomlFile.this.getTomlContents(ctx);
                    if (StringUtils.isBlank((String)tomlContents)) {
                        return document.withValues(Collections.emptyList());
                    }
                    if (document.printAll().equals(tomlContents.trim())) {
                        return document;
                    }
                    Optional<SourceFile> sourceFiles = TomlParser.builder().build().parse(tomlContents).findFirst();
                    if (sourceFiles.isPresent() && (sourceFile = sourceFiles.get()) instanceof Toml.Document) {
                        return document.withValues(((Toml.Document)sourceFile).getValues());
                    }
                }
                return document;
            }
        };
    }

    @Language(value="toml")
    private String getTomlContents(ExecutionContext ctx) {
        String tomlContents = this.fileContents;
        if (tomlContents == null && this.fileContentsUrl != null) {
            return Remote.builder((Path)Paths.get(this.relativeFileName, new String[0])).build(URI.create(this.fileContentsUrl)).printAll((Object)ctx);
        }
        return tomlContents == null ? "" : tomlContents;
    }

    @Generated
    public CreateTomlFile(String relativeFileName, @Language(value="toml") @Nullable String fileContents, @Nullable String fileContentsUrl, @Nullable Boolean overwriteExisting) {
        this.relativeFileName = relativeFileName;
        this.fileContents = fileContents;
        this.fileContentsUrl = fileContentsUrl;
        this.overwriteExisting = overwriteExisting;
    }

    @Generated
    public String getRelativeFileName() {
        return this.relativeFileName;
    }

    @Language(value="toml")
    @Generated
    public @Nullable String getFileContents() {
        return this.fileContents;
    }

    @Generated
    public @Nullable String getFileContentsUrl() {
        return this.fileContentsUrl;
    }

    @Generated
    public @Nullable Boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "CreateTomlFile(relativeFileName=" + this.getRelativeFileName() + ", fileContents=" + this.getFileContents() + ", fileContentsUrl=" + this.getFileContentsUrl() + ", overwriteExisting=" + this.getOverwriteExisting() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTomlFile)) {
            return false;
        }
        CreateTomlFile other = (CreateTomlFile)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overwriteExisting = this.getOverwriteExisting();
        Boolean other$overwriteExisting = other.getOverwriteExisting();
        if (this$overwriteExisting == null ? other$overwriteExisting != null : !((Object)this$overwriteExisting).equals(other$overwriteExisting)) {
            return false;
        }
        String this$relativeFileName = this.getRelativeFileName();
        String other$relativeFileName = other.getRelativeFileName();
        if (this$relativeFileName == null ? other$relativeFileName != null : !this$relativeFileName.equals(other$relativeFileName)) {
            return false;
        }
        String this$fileContents = this.getFileContents();
        String other$fileContents = other.getFileContents();
        if (this$fileContents == null ? other$fileContents != null : !this$fileContents.equals(other$fileContents)) {
            return false;
        }
        String this$fileContentsUrl = this.getFileContentsUrl();
        String other$fileContentsUrl = other.getFileContentsUrl();
        if (this$fileContentsUrl == null ? other$fileContentsUrl != null : !this$fileContentsUrl.equals(other$fileContentsUrl)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof CreateTomlFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overwriteExisting = this.getOverwriteExisting();
        result = result * 59 + ($overwriteExisting == null ? 43 : ((Object)$overwriteExisting).hashCode());
        String $relativeFileName = this.getRelativeFileName();
        result = result * 59 + ($relativeFileName == null ? 43 : $relativeFileName.hashCode());
        String $fileContents = this.getFileContents();
        result = result * 59 + ($fileContents == null ? 43 : $fileContents.hashCode());
        String $fileContentsUrl = this.getFileContentsUrl();
        result = result * 59 + ($fileContentsUrl == null ? 43 : $fileContentsUrl.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

