/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.coding;

import java.util.Arrays;
import org.openrewrite.tools.checkstyle.PropertyType;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.XdocsPropertyType;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.CheckUtil;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;
import org.openrewrite.tools.checkstyle.utils.ScopeUtil;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@StatelessCheck
public class MagicNumberCheck
extends AbstractCheck {
    public static final String MSG_KEY = "magic.number";
    @XdocsPropertyType(value=PropertyType.TOKEN_ARRAY)
    private int[] constantWaiverParentToken = new int[]{80, 29, 28, 32, 31, 23, 34, 136, 27, 60, 127, 125, 126};
    private double[] ignoreNumbers = new double[]{-1.0, 0.0, 1.0, 2.0};
    private boolean ignoreHashCodeMethod;
    private boolean ignoreAnnotation;
    private boolean ignoreFieldDeclaration;
    private boolean ignoreAnnotationElementDefaults = true;

    public MagicNumberCheck() {
        Arrays.sort(this.constantWaiverParentToken);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{142, 140, 137, 141};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!(!this.shouldTestAnnotationArgs(ast) || !this.shouldTestAnnotationDefaults(ast) || this.isInIgnoreList(ast) || this.ignoreHashCodeMethod && MagicNumberCheck.isInHashCodeMethod(ast))) {
            DetailAST constantDefAST = MagicNumberCheck.findContainingConstantDef(ast);
            if (constantDefAST == null) {
                if (!this.ignoreFieldDeclaration || !MagicNumberCheck.isFieldDeclaration(ast)) {
                    this.reportMagicNumber(ast);
                }
            } else {
                boolean found = this.isMagicNumberExists(ast, constantDefAST);
                if (found) {
                    this.reportMagicNumber(ast);
                }
            }
        }
    }

    private boolean shouldTestAnnotationArgs(DetailAST ast) {
        return !this.ignoreAnnotation || !MagicNumberCheck.isChildOf(ast, 159);
    }

    private boolean shouldTestAnnotationDefaults(DetailAST ast) {
        return !this.ignoreAnnotationElementDefaults || !MagicNumberCheck.isChildOf(ast, 94);
    }

    private boolean isMagicNumberExists(DetailAST ast, DetailAST constantDefAST) {
        boolean found = false;
        for (DetailAST astNode = ast.getParent(); astNode != constantDefAST; astNode = astNode.getParent()) {
            int type = astNode.getType();
            if (Arrays.binarySearch(this.constantWaiverParentToken, type) >= 0) continue;
            found = true;
            break;
        }
        return found;
    }

    private static DetailAST findContainingConstantDef(DetailAST ast) {
        DetailAST varDefAST;
        for (varDefAST = ast; varDefAST != null && varDefAST.getType() != 10 && varDefAST.getType() != 155; varDefAST = varDefAST.getParent()) {
        }
        DetailAST constantDef = null;
        if (varDefAST != null) {
            if (ScopeUtil.isInInterfaceOrAnnotationBlock(varDefAST) || varDefAST.getType() == 155) {
                constantDef = varDefAST;
            } else {
                DetailAST modifiersAST = varDefAST.findFirstToken(5);
                if (modifiersAST.findFirstToken(39) != null) {
                    constantDef = varDefAST;
                }
            }
        }
        return constantDef;
    }

    private void reportMagicNumber(DetailAST ast) {
        String text = ast.getText();
        DetailAST parent = ast.getParent();
        DetailAST reportAST = ast;
        if (parent.getType() == 31) {
            reportAST = parent;
            text = "-" + text;
        } else if (parent.getType() == 32) {
            reportAST = parent;
            text = "+" + text;
        }
        this.log(reportAST, MSG_KEY, text);
    }

    private static boolean isInHashCodeMethod(DetailAST ast) {
        DetailAST identAST;
        DetailAST methodDefAST;
        for (methodDefAST = ast.getParent(); methodDefAST != null && methodDefAST.getType() != 9; methodDefAST = methodDefAST.getParent()) {
        }
        boolean inHashCodeMethod = false;
        if (methodDefAST != null && "hashCode".equals((identAST = methodDefAST.findFirstToken(58)).getText())) {
            DetailAST paramAST = methodDefAST.findFirstToken(20);
            inHashCodeMethod = !paramAST.hasChildren();
        }
        return inHashCodeMethod;
    }

    private boolean isInIgnoreList(DetailAST ast) {
        double value = CheckUtil.parseDouble(ast.getText(), ast.getType());
        DetailAST parent = ast.getParent();
        if (parent.getType() == 31) {
            value = -1.0 * value;
        }
        return Arrays.binarySearch(this.ignoreNumbers, value) >= 0;
    }

    private static boolean isFieldDeclaration(DetailAST ast) {
        DetailAST varDefAST;
        for (varDefAST = ast; varDefAST != null && varDefAST.getType() != 10; varDefAST = varDefAST.getParent()) {
        }
        return varDefAST != null && (varDefAST.getParent().getParent().getType() == 14 || varDefAST.getParent().getParent().getType() == 199);
    }

    public void setConstantWaiverParentToken(String ... tokens) {
        this.constantWaiverParentToken = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            this.constantWaiverParentToken[i] = TokenUtil.getTokenId(tokens[i]);
        }
        Arrays.sort(this.constantWaiverParentToken);
    }

    public void setIgnoreNumbers(double ... list) {
        this.ignoreNumbers = new double[list.length];
        System.arraycopy(list, 0, this.ignoreNumbers, 0, list.length);
        Arrays.sort(this.ignoreNumbers);
    }

    public void setIgnoreHashCodeMethod(boolean ignoreHashCodeMethod) {
        this.ignoreHashCodeMethod = ignoreHashCodeMethod;
    }

    public void setIgnoreAnnotation(boolean ignoreAnnotation) {
        this.ignoreAnnotation = ignoreAnnotation;
    }

    public void setIgnoreFieldDeclaration(boolean ignoreFieldDeclaration) {
        this.ignoreFieldDeclaration = ignoreFieldDeclaration;
    }

    public void setIgnoreAnnotationElementDefaults(boolean ignoreAnnotationElementDefaults) {
        this.ignoreAnnotationElementDefaults = ignoreAnnotationElementDefaults;
    }

    private static boolean isChildOf(DetailAST ast, int type) {
        boolean result = false;
        DetailAST node = ast;
        do {
            if (node.getType() != type) continue;
            result = true;
            break;
        } while ((node = node.getParent()) != null);
        return result;
    }
}

