/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.search.FindDeprecatedClasses;
import org.openrewrite.java.search.FindDeprecatedFields;
import org.openrewrite.java.search.FindDeprecatedMethods;

public final class FindDeprecatedUses
extends Recipe {
    @Option(displayName="Type pattern", description="A type pattern that is used to find deprecations from certain types.", example="org.springframework..*", required=false)
    private final @Nullable String typePattern;
    @Option(displayName="Match inherited", description="When enabled, find types that inherit from a deprecated type.", required=false)
    private final @Nullable Boolean matchInherited;
    @Option(displayName="Ignore deprecated scopes", description="When a deprecated type is used in a deprecated method or class, ignore it.", required=false)
    private final @Nullable Boolean ignoreDeprecatedScopes;
    private final String displayName = "Find uses of deprecated classes, methods, and fields";
    private final String description = "Find deprecated uses of methods, fields, and types. Optionally ignore those classes that are inside deprecated scopes.";

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new FindDeprecatedMethods(this.typePattern == null || this.typePattern.isEmpty() ? null : this.typePattern + " *(..)", this.ignoreDeprecatedScopes), new FindDeprecatedClasses(this.typePattern, this.matchInherited, this.ignoreDeprecatedScopes), new FindDeprecatedFields(this.typePattern, this.matchInherited, this.ignoreDeprecatedScopes)});
    }

    public String getInstanceNameSuffix() {
        if (this.typePattern != null) {
            return "matching `" + this.typePattern + "`";
        }
        return super.getInstanceNameSuffix();
    }

    @Generated
    public FindDeprecatedUses(@Nullable String typePattern, @Nullable Boolean matchInherited, @Nullable Boolean ignoreDeprecatedScopes) {
        this.typePattern = typePattern;
        this.matchInherited = matchInherited;
        this.ignoreDeprecatedScopes = ignoreDeprecatedScopes;
    }

    @Generated
    public @Nullable String getTypePattern() {
        return this.typePattern;
    }

    @Generated
    public @Nullable Boolean getMatchInherited() {
        return this.matchInherited;
    }

    @Generated
    public @Nullable Boolean getIgnoreDeprecatedScopes() {
        return this.ignoreDeprecatedScopes;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindDeprecatedUses(typePattern=" + this.getTypePattern() + ", matchInherited=" + this.getMatchInherited() + ", ignoreDeprecatedScopes=" + this.getIgnoreDeprecatedScopes() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDeprecatedUses)) {
            return false;
        }
        FindDeprecatedUses other = (FindDeprecatedUses)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchInherited = this.getMatchInherited();
        Boolean other$matchInherited = other.getMatchInherited();
        if (this$matchInherited == null ? other$matchInherited != null : !((Object)this$matchInherited).equals(other$matchInherited)) {
            return false;
        }
        Boolean this$ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        Boolean other$ignoreDeprecatedScopes = other.getIgnoreDeprecatedScopes();
        if (this$ignoreDeprecatedScopes == null ? other$ignoreDeprecatedScopes != null : !((Object)this$ignoreDeprecatedScopes).equals(other$ignoreDeprecatedScopes)) {
            return false;
        }
        String this$typePattern = this.getTypePattern();
        String other$typePattern = other.getTypePattern();
        if (this$typePattern == null ? other$typePattern != null : !this$typePattern.equals(other$typePattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindDeprecatedUses;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchInherited = this.getMatchInherited();
        result = result * 59 + ($matchInherited == null ? 43 : ((Object)$matchInherited).hashCode());
        Boolean $ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        result = result * 59 + ($ignoreDeprecatedScopes == null ? 43 : ((Object)$ignoreDeprecatedScopes).hashCode());
        String $typePattern = this.getTypePattern();
        result = result * 59 + ($typePattern == null ? 43 : $typePattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

