/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.search.UsesType;

public final class DoesNotUseType
extends Recipe {
    @Option(displayName="Fully-qualified type name", description="A fully-qualified type name, that is used to find matching type references. Supports glob expressions. `java..*` finds every type from every subpackage of the `java` package.", example="java.util.List")
    private final String fullyQualifiedTypeName;
    @Option(displayName="Include implicit type references", description="Whether to include implicit type references, such as those in method signatures.", required=false)
    private final @Nullable Boolean includeImplicit;
    private final String displayName = "Check whether a type is **not** in use";
    private final String description = "Useful as a precondition to skip over compilation units using the argument type.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.not(new UsesType(this.fullyQualifiedTypeName, this.includeImplicit));
    }

    @Generated
    public DoesNotUseType(String fullyQualifiedTypeName, @Nullable Boolean includeImplicit) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
        this.includeImplicit = includeImplicit;
    }

    @Generated
    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    @Generated
    public @Nullable Boolean getIncludeImplicit() {
        return this.includeImplicit;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DoesNotUseType(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ", includeImplicit=" + this.getIncludeImplicit() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoesNotUseType)) {
            return false;
        }
        DoesNotUseType other = (DoesNotUseType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$includeImplicit = this.getIncludeImplicit();
        Boolean other$includeImplicit = other.getIncludeImplicit();
        if (this$includeImplicit == null ? other$includeImplicit != null : !((Object)this$includeImplicit).equals(other$includeImplicit)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        if (this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DoesNotUseType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $includeImplicit = this.getIncludeImplicit();
        result = result * 59 + ($includeImplicit == null ? 43 : ((Object)$includeImplicit).hashCode());
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

