/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import org.jspecify.annotations.Nullable;
import org.objectweb.asm.TypePath;

class TypeAnnotationSupport {
    TypeAnnotationSupport() {
    }

    public static String formatTypeAnnotation(int typeRef, @Nullable TypePath typePath, String annotation) {
        String typeRefHex = String.format("%08x", typeRef);
        String pathString = typePath != null ? typePath.toString() : "";
        return typeRefHex + ":" + pathString + ":" + annotation;
    }

    public static class TypeAnnotationInfo {
        public final int typeRef;
        public final @Nullable TypePath typePath;
        public final String annotation;

        private TypeAnnotationInfo(int typeRef, @Nullable TypePath typePath, String annotation) {
            this.typeRef = typeRef;
            this.typePath = typePath;
            this.annotation = annotation;
        }

        public static TypeAnnotationInfo parse(String serialized) {
            int EXPECTED_PARTS = 3;
            String[] parts = serialized.split(":", 3);
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid type annotation format: " + serialized);
            }
            String typeRefHex = parts[0];
            String pathString = parts[1];
            String annotation = parts[2];
            int typeRef = (int)Long.parseLong(typeRefHex, 16);
            TypePath typePath = null;
            if (!pathString.isEmpty()) {
                typePath = TypePath.fromString((String)pathString);
            }
            return new TypeAnnotationInfo(typeRef, typePath, annotation);
        }
    }
}

