/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.AutodetectGeneralFormatStyle;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.Style;

public class EmptyNewlineAtEndOfFile
extends Recipe {
    final String displayName = "End files with a single newline";
    final String description = "Some tools work better when files end with an empty line.";
    final Set<String> tags = Collections.singleton("RSPEC-S113");
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    JavaSourceFile cu = (JavaSourceFile)tree;
                    GeneralFormatStyle generalFormatStyle = (GeneralFormatStyle)Style.from(GeneralFormatStyle.class, (SourceFile)cu, () -> AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(cu));
                    String lineEnding = generalFormatStyle.newLine();
                    Space eof = cu.getEof();
                    if (StringUtils.isBlank((String)eof.getLastWhitespace()) && eof.getLastWhitespace().chars().filter(c -> c == 10).count() != 1L) {
                        List<Comment> comments = eof.getComments();
                        if (comments.isEmpty()) {
                            return cu.withEof(Space.format(lineEnding));
                        }
                        return cu.withEof(cu.getEof().withComments(ListUtils.mapLast(comments, it -> it.withSuffix(lineEnding))));
                    }
                    return cu;
                }
                return (J)tree;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

