/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.format.AutoFormatVisitor;
import org.openrewrite.style.NamedStyles;

public final class AutoFormat
extends Recipe {
    @Option(displayName="Style YAML", description="An OpenRewrite [style](https://docs.openrewrite.org/concepts-and-explanations/styles) formatted in YAML.", example="type: specs.openrewrite.org/v1beta/style\nname: com.yourorg.YesTabsNoStarImports\nstyleConfigs:\n  - org.openrewrite.java.style.TabsAndIndentsStyle:\n      useTabCharacter: true", required=false)
    private final @Nullable String style;
    @Option(displayName="Remove custom line breaks", description="Do you want to remove custom line breaks? (default false)", required=false)
    private final @Nullable Boolean removeCustomLineBreaks;
    private final String displayName = "Format Java code";
    private final String description = "Format Java code using a standard comprehensive set of Java formatting recipes.";

    @JsonCreator
    public AutoFormat(@Nullable String style, @Nullable Boolean removeCustomLineBreaks) {
        this.style = style;
        this.removeCustomLineBreaks = removeCustomLineBreaks;
    }

    @Deprecated
    public AutoFormat(@Nullable String style) {
        this(style, null);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AutoFormatVisitor<ExecutionContext>(null, Boolean.TRUE.equals(this.removeCustomLineBreaks), this.computeNamedStyles());
    }

    private NamedStyles[] computeNamedStyles() {
        if (this.style == null) {
            return new NamedStyles[0];
        }
        return new YamlResourceLoader((InputStream)new ByteArrayInputStream(this.style.getBytes()), URI.create("AutoFormat$style"), new Properties()).listStyles().toArray(new NamedStyles[0]);
    }

    @Generated
    public @Nullable String getStyle() {
        return this.style;
    }

    @Generated
    public @Nullable Boolean getRemoveCustomLineBreaks() {
        return this.removeCustomLineBreaks;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AutoFormat(style=" + this.getStyle() + ", removeCustomLineBreaks=" + this.getRemoveCustomLineBreaks() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoFormat)) {
            return false;
        }
        AutoFormat other = (AutoFormat)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$removeCustomLineBreaks = this.getRemoveCustomLineBreaks();
        Boolean other$removeCustomLineBreaks = other.getRemoveCustomLineBreaks();
        if (this$removeCustomLineBreaks == null ? other$removeCustomLineBreaks != null : !((Object)this$removeCustomLineBreaks).equals(other$removeCustomLineBreaks)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AutoFormat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $removeCustomLineBreaks = this.getRemoveCustomLineBreaks();
        result = result * 59 + ($removeCustomLineBreaks == null ? 43 : ((Object)$removeCustomLineBreaks).hashCode());
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

