/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.ai;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.table.TokenCount;
import org.openrewrite.java.tree.J;

public final class MethodDefinitionLength
extends Recipe {
    private final transient TokenCount tokens = new TokenCount(this);
    private final String displayName = "Calculate token length of method definitions";
    private final String description = "Locates method definitions and predicts the number of token in each.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J md = super.visitMethodDeclaration(method, ctx);
                J.ClassDeclaration cd = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (cd == null) {
                    return md;
                }
                int numberOfTokens = (int)((double)md.printTrimmed(this.getCursor()).length() / 3.5);
                MethodDefinitionLength.this.tokens.insertRow(ctx, new TokenCount.Row(((J.MethodDeclaration)md).getSimpleName(), numberOfTokens));
                return md;
            }
        };
    }

    @Generated
    public MethodDefinitionLength() {
    }

    @Generated
    public TokenCount getTokens() {
        return this.tokens;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MethodDefinitionLength(tokens=" + (Object)((Object)this.getTokens()) + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodDefinitionLength)) {
            return false;
        }
        MethodDefinitionLength other = (MethodDefinitionLength)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MethodDefinitionLength;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

