/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.SimplifySingleElementAnnotation;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class RemoveAnnotationAttribute
extends Recipe {
    @Option(displayName="Annotation Type", description="The fully qualified name of the annotation.", example="org.junit.Test")
    private final String annotationType;
    @Option(displayName="Attribute name", description="The name of attribute to remove.", example="timeout")
    private final String attributeName;
    private final String displayName = "Remove annotation attribute";
    private final String description = "Some annotations accept arguments. This recipe removes an existing attribute.";

    public String getInstanceNameSuffix() {
        String shortType = this.annotationType.substring(this.annotationType.lastIndexOf(46) + 1);
        return String.format("`@%s(%s)`", shortType, this.attributeName);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesType(this.annotationType, false), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            private final AnnotationMatcher annotationMatcher;
            {
                this.annotationMatcher = new AnnotationMatcher(RemoveAnnotationAttribute.this.annotationType);
            }

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J a = super.visitAnnotation(annotation, ctx);
                if (!this.annotationMatcher.matches((J.Annotation)a)) {
                    return a;
                }
                AtomicBoolean didPassFirstAttribute = new AtomicBoolean(false);
                AtomicBoolean shouldTrimNextPrefix = new AtomicBoolean(false);
                J.Annotation withoutAttribute = ((J.Annotation)a).withArguments(ListUtils.map(((J.Annotation)a).getArguments(), arg -> {
                    try {
                        if (arg instanceof J.Assignment) {
                            J.Assignment assignment = (J.Assignment)arg;
                            J.Identifier variable = (J.Identifier)assignment.getVariable();
                            if (RemoveAnnotationAttribute.this.attributeName.equals(variable.getSimpleName())) {
                                if (!didPassFirstAttribute.get()) {
                                    shouldTrimNextPrefix.set(true);
                                }
                                Expression expression = null;
                                return expression;
                            }
                        } else if ("value".equals(RemoveAnnotationAttribute.this.attributeName)) {
                            if (!didPassFirstAttribute.get()) {
                                shouldTrimNextPrefix.set(true);
                            }
                            Expression expression = null;
                            return expression;
                        }
                        if (shouldTrimNextPrefix.get()) {
                            shouldTrimNextPrefix.set(false);
                            Expression expression = (Expression)arg.withPrefix(arg.getPrefix().withWhitespace(""));
                            return expression;
                        }
                    }
                    finally {
                        didPassFirstAttribute.set(true);
                    }
                    return arg;
                }));
                if (a != withoutAttribute && withoutAttribute.getArguments() != null && withoutAttribute.getArguments().size() == 1) {
                    this.doAfterVisit(SimplifySingleElementAnnotation.modifyOnly(withoutAttribute));
                }
                return withoutAttribute;
            }
        });
    }

    @Generated
    public RemoveAnnotationAttribute(String annotationType, String attributeName) {
        this.annotationType = annotationType;
        this.attributeName = attributeName;
    }

    @Generated
    public String getAnnotationType() {
        return this.annotationType;
    }

    @Generated
    public String getAttributeName() {
        return this.attributeName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveAnnotationAttribute(annotationType=" + this.getAnnotationType() + ", attributeName=" + this.getAttributeName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveAnnotationAttribute)) {
            return false;
        }
        RemoveAnnotationAttribute other = (RemoveAnnotationAttribute)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$annotationType = this.getAnnotationType();
        String other$annotationType = other.getAnnotationType();
        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveAnnotationAttribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $annotationType = this.getAnnotationType();
        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

