/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markup;

public final class RecipeMarkupDemonstration
extends Recipe {
    @Option(displayName="Level", description="The `Markup#Level` to add.", valid={"debug", "info", "warning", "error"})
    private final String level;
    private final String displayName = "Demonstrate rendering of `Markup` markers";
    private final String description = "Tooling may decide to elide or display differently markup of different levels.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                switch (RecipeMarkupDemonstration.this.level) {
                    case "info": {
                        return Markup.info((Tree)sourceFile, (String)"This is an info message.");
                    }
                    case "warning": {
                        return Markup.warn((Tree)sourceFile, (Throwable)new IllegalStateException("This is a warning message."));
                    }
                    case "error": {
                        return Markup.error((Tree)sourceFile, (Throwable)new IllegalStateException("This is an error message."));
                    }
                }
                return Markup.debug((Tree)sourceFile, (String)"This is a debug message.");
            }
        };
    }

    @Generated
    public RecipeMarkupDemonstration(String level) {
        this.level = level;
    }

    @Generated
    public String getLevel() {
        return this.level;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RecipeMarkupDemonstration(level=" + this.getLevel() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeMarkupDemonstration)) {
            return false;
        }
        RecipeMarkupDemonstration other = (RecipeMarkupDemonstration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RecipeMarkupDemonstration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

