/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.util.HashMap;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractDartCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DartClientCodegen
extends AbstractDartCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(DartClientCodegen.class);
    public static final String SERIALIZATION_LIBRARY_NATIVE = "native_serialization";

    public DartClientCodegen() {
        CliOption serializationLibrary = CliOption.newString("serializationLibrary", "Specify serialization library");
        serializationLibrary.setDefault(SERIALIZATION_LIBRARY_NATIVE);
        HashMap<String, String> serializationOptions = new HashMap<String, String>();
        serializationOptions.put(SERIALIZATION_LIBRARY_NATIVE, "Use native serializer, backwards compatible");
        serializationLibrary.setEnum(serializationOptions);
        this.cliOptions.add(serializationLibrary);
        this.sourceFolder = "";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.get("serializationLibrary") == null) {
            this.library = SERIALIZATION_LIBRARY_NATIVE;
            this.LOGGER.debug("Serialization library not set, using default {}", (Object)SERIALIZATION_LIBRARY_NATIVE);
        } else {
            this.library = this.additionalProperties.get("serializationLibrary").toString();
        }
        this.setSerializationLibrary();
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("analysis_options.mustache", "", "analysis_options.yaml"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", this.libPath, "api_client.dart"));
        this.supportingFiles.add(new SupportingFile("api_exception.mustache", this.libPath, "api_exception.dart"));
        this.supportingFiles.add(new SupportingFile("api_helper.mustache", this.libPath, "api_helper.dart"));
        this.supportingFiles.add(new SupportingFile("apilib.mustache", this.libPath, "api.dart"));
        String authFolder = this.libPath + "auth";
        this.supportingFiles.add(new SupportingFile("auth/authentication.mustache", authFolder, "authentication.dart"));
        this.supportingFiles.add(new SupportingFile("auth/http_basic_auth.mustache", authFolder, "http_basic_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/http_bearer_auth.mustache", authFolder, "http_bearer_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/api_key_auth.mustache", authFolder, "api_key_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/oauth.mustache", authFolder, "oauth.dart"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("travis.mustache", "", ".travis.yml"));
    }

    private void setSerializationLibrary() {
        String serialization_library = this.getLibrary();
        this.LOGGER.info("Using serialization library {}", (Object)serialization_library);
        switch (serialization_library) {
            default: 
        }
        this.additionalProperties.put(SERIALIZATION_LIBRARY_NATIVE, "true");
    }
}

