/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.Resource;
import org.nuiton.util.ResourceNotFoundException;
import org.nuiton.util.StringUtil;

public class ResourceResolver
implements URIResolver {
    private static final Log log = LogFactory.getLog(ResourceResolver.class);
    protected static final SortedMap<String, Source> sourceCache = new TreeMap<String, Source>();
    protected static final Set<String> unresolvedCache = new HashSet<String>();
    public static final Pattern HREF_PATTERN = Pattern.compile("([a-zA-Z]+)\\:\\/\\/(.+)");
    protected String base;
    protected boolean verbose = log.isDebugEnabled();
    protected ClassLoader cl = this.getClass().getClassLoader();

    public static synchronized void clearCache() {
        sourceCache.clear();
        unresolvedCache.clear();
    }

    public ResourceResolver() {
        this(null);
    }

    public ResourceResolver(String base) {
        if (base != null && base.endsWith("/") && base.length() > 1) {
            base = base.substring(0, base.length() - 1);
        }
        this.base = base;
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + ", base : " + this.base));
        }
    }

    @Override
    public synchronized Source resolve(String href, String base) {
        Source source;
        Matcher matcher;
        if (unresolvedCache.contains(href)) {
            if (this.verbose) {
                log.info((Object)("Skip unresolved " + href));
            }
            return null;
        }
        if (sourceCache.containsKey(href)) {
            if (this.verbose) {
                log.info((Object)("use cached source " + href));
            }
            return (Source)sourceCache.get(href);
        }
        if (this.verbose) {
            log.info((Object)("Resolving " + href));
        }
        if ((matcher = HREF_PATTERN.matcher(href)).matches()) {
            String path = matcher.group(2);
            source = this.findHrefSource(path);
        } else {
            source = this.findRelativeSource(href);
        }
        if (source == null) {
            if (this.verbose) {
                log.info((Object)("detect unresolved source " + href));
            }
            unresolvedCache.add(href);
        } else {
            if (this.verbose) {
                log.info((Object)("detect cacheable  source " + href));
            }
            sourceCache.put(href, source);
        }
        return source;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setCl(ClassLoader cl) {
        this.cl = cl;
    }

    protected Source findHrefSource(String path) {
        ClassLoader cl2;
        long t0 = System.nanoTime();
        int beginIndex = path.lastIndexOf(47);
        String filename = beginIndex > -1 ? path.substring(beginIndex + 1) : path;
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        String resource = ".*/" + filename;
        if (this.verbose) {
            log.info((Object)("will discover " + resource));
        }
        URL url = null;
        List<URL> urls = null;
        URLClassLoader ucl = null;
        if (this.cl == null && (cl2 = this.getClass().getClassLoader()) instanceof URLClassLoader) {
            ucl = (URLClassLoader)cl2;
        }
        if (this.cl instanceof URLClassLoader) {
            ucl = (URLClassLoader)this.cl;
        }
        try {
            urls = Resource.getURLs(resource, ucl);
        }
        catch (ResourceNotFoundException rnfe) {
            // empty catch block
        }
        if (urls != null && !urls.isEmpty()) {
            url = urls.get(0);
        }
        StreamSource source = null;
        if (url != null) {
            if (this.verbose) {
                log.info((Object)url.toString());
            }
            source = new StreamSource(url.toString());
        }
        if (this.verbose) {
            String time = StringUtil.convertTime(System.nanoTime() - t0);
            log.info((Object)("resolved in " + time));
        }
        return source;
    }

    protected Source findRelativeSource(String path) {
        long t0 = System.nanoTime();
        String filename = path;
        String resource = this.base != null ? this.base + "/" + filename : filename;
        if (this.verbose) {
            log.info((Object)("will discover " + resource));
        }
        URL url = Resource.getURLOrNull(resource);
        StreamSource source = null;
        if (url != null) {
            if (this.verbose) {
                log.info((Object)url.toString());
            }
            source = new StreamSource(url.toString());
        }
        if (this.verbose) {
            String time = StringUtil.convertTime(System.nanoTime() - t0);
            log.info((Object)("resolved in " + time));
        }
        return source;
    }
}

