/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ext.udc;

import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Function2;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.Settings;

public class UdcSettings {
    public static final Setting<Boolean> udc_enabled = Settings.setting((String)"neo4j.ext.udc.enabled", (Function)Enabled.UNLESS_EXPLICITLY_DISABLED, (String)Enabled.AS_DEFAULT_VALUE);
    public static final Setting<Integer> first_delay = Settings.setting((String)"neo4j.ext.udc.first_delay", (Function)Settings.INTEGER, (String)Integer.toString(600000), (Function2[])new Function2[]{Settings.min((Comparable)Integer.valueOf(1))});
    public static final Setting<Integer> interval = Settings.setting((String)"neo4j.ext.udc.interval", (Function)Settings.INTEGER, (String)Integer.toString(86400000), (Function2[])new Function2[]{Settings.min((Comparable)Integer.valueOf(1))});
    public static final Setting<HostnamePort> udc_host = Settings.setting((String)"neo4j.ext.udc.host", (Function)Settings.HOSTNAME_PORT, (String)"udc.neo4j.org");
    public static final Setting<String> udc_source = Settings.setting((String)"neo4j.ext.udc.source", (Function)Settings.STRING, (String)Settings.NO_DEFAULT, (Function2[])new Function2[]{Settings.illegalValueMessage((String)"Must be a valid source", (Function2)Settings.matches((String)".+"))});
    public static final Setting<String> udc_registration_key = Settings.setting((String)"neo4j.ext.udc.reg", (Function)Settings.STRING, (String)"unreg", (Function2[])new Function2[]{Settings.illegalValueMessage((String)"Must be a valid registration id", (Function2)Settings.matches((String)".+"))});

    private static enum Enabled implements Function<String, Boolean>
    {
        UNLESS_EXPLICITLY_DISABLED;

        static final String AS_DEFAULT_VALUE;

        public Boolean apply(String from) {
            if (from == AS_DEFAULT_VALUE) {
                String enabled = System.getProperty(udc_enabled.name());
                if ("false".equalsIgnoreCase(enabled)) {
                    String disabled = System.getProperty(Enabled.udc_disabled());
                    if (disabled == null || disabled.equalsIgnoreCase("true")) {
                        return false;
                    }
                } else if ("true".equalsIgnoreCase(System.getProperty(Enabled.udc_disabled()))) {
                    return enabled != null;
                }
                return true;
            }
            if ("false".equalsIgnoreCase(from)) {
                String enabled = System.getProperty(udc_enabled.name());
                String disabled = System.getProperty(Enabled.udc_disabled());
                if ((enabled == null || enabled.equalsIgnoreCase("false")) && (disabled == null || disabled.equalsIgnoreCase("true"))) {
                    return false;
                }
                return true;
            }
            return true;
        }

        private static String udc_disabled() {
            return udc_enabled.name().replace("enabled", "disable");
        }

        static {
            AS_DEFAULT_VALUE = new String("true");
        }
    }
}

