/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PropertyKeyValue
implements StorageProperty {
    private final int propertyKeyId;
    private final Value value;

    public PropertyKeyValue(int propertyKeyId, Value value) {
        assert (value != null);
        this.propertyKeyId = propertyKeyId;
        this.value = value;
    }

    @Override
    public int propertyKeyId() {
        return this.propertyKeyId;
    }

    @Override
    public Value value() {
        return this.value;
    }

    @Override
    public boolean isDefined() {
        return this.value != Values.NO_VALUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyKeyValue that = (PropertyKeyValue)o;
        return this.propertyKeyId == that.propertyKeyId && this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.propertyKeyId;
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

