/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.util.VisibleForTesting;

public class CountsDelta
implements CountsAccessor,
CountsAccessor.Updater {
    private static final long DEFAULT_COUNT = 0L;
    private final Map<Key, MutableLong> counts = new HashMap<Key, MutableLong>();

    @Override
    public long nodeCount(int labelId) {
        return this.counts(CountsDelta.nodeKey(labelId)).longValue();
    }

    @Override
    public void incrementNodeCount(long labelId, long delta) {
        this.counts(CountsDelta.nodeKey(labelId)).add(delta);
    }

    @Override
    public long relationshipCount(int startLabelId, int typeId, int endLabelId) {
        return this.counts(CountsDelta.relationshipKey(startLabelId, typeId, endLabelId)).longValue();
    }

    @Override
    public void incrementRelationshipCount(long startLabelId, int typeId, long endLabelId, long delta) {
        if (delta != 0L) {
            this.counts(CountsDelta.relationshipKey(startLabelId, typeId, endLabelId)).add(delta);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void accept(CountsVisitor visitor) {
        for (Map.Entry<Key, MutableLong> entry : this.counts.entrySet()) {
            MutableLong register = entry.getValue();
            entry.getKey().accept(visitor, register.longValue());
        }
    }

    public boolean hasChanges() {
        return !this.counts.isEmpty();
    }

    public List<Difference> verify(CountsVisitor.Visitable visitable) {
        Verifier verifier = new Verifier(this.counts);
        visitable.accept(verifier);
        return verifier.differences();
    }

    public void addNode(long[] labels) {
        this.incrementNodeCount(-1L, 1L);
        for (long label : labels) {
            this.incrementNodeCount((int)label, 1L);
        }
    }

    public void addRelationship(long[] startLabels, int type, long[] endLabels) {
        this.incrementRelationshipCount(-1L, -1, -1L, 1L);
        this.incrementRelationshipCount(-1L, type, -1L, 1L);
        for (long startLabelId : startLabels) {
            this.incrementRelationshipCount((int)startLabelId, -1, -1L, 1L);
            this.incrementRelationshipCount((int)startLabelId, type, -1L, 1L);
        }
        for (long endLabelId : endLabels) {
            this.incrementRelationshipCount(-1L, -1, (int)endLabelId, 1L);
            this.incrementRelationshipCount(-1L, type, (int)endLabelId, 1L);
        }
    }

    private MutableLong counts(Key key) {
        return this.counts.computeIfAbsent(key, k -> new MutableLong(0L));
    }

    @VisibleForTesting
    public static Key nodeKey(long labelId) {
        return new Key(new long[]{labelId}){

            @Override
            void accept(CountsVisitor visitor, long count) {
                visitor.visitNodeCount(Math.toIntExact(this.tokens[0]), count);
            }
        };
    }

    @VisibleForTesting
    public static Key relationshipKey(long startLabelId, long relationshipTypeId, long endLabelId) {
        return new Key(new long[]{startLabelId, relationshipTypeId, endLabelId}){

            @Override
            void accept(CountsVisitor visitor, long count) {
                visitor.visitRelationshipCount(Math.toIntExact(this.tokens[0]), Math.toIntExact(this.tokens[1]), Math.toIntExact(this.tokens[2]), count);
            }
        };
    }

    @VisibleForTesting
    public static abstract class Key {
        final long[] tokens;

        Key(long ... tokens) {
            this.tokens = tokens;
        }

        abstract void accept(CountsVisitor var1, long var2);

        public boolean equals(Object o) {
            return o != null && this.getClass() == o.getClass() && Arrays.equals(this.tokens, ((Key)o).tokens);
        }

        public int hashCode() {
            return Arrays.hashCode(this.tokens);
        }
    }

    private static class Verifier
    implements CountsVisitor {
        private final Map<Key, MutableLong> counts;
        private final List<Difference> differences = new ArrayList<Difference>();

        Verifier(Map<Key, MutableLong> counts) {
            this.counts = new HashMap<Key, MutableLong>(counts);
        }

        @Override
        public void visitNodeCount(int labelId, long count) {
            this.verify(CountsDelta.nodeKey(labelId), count);
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
            this.verify(CountsDelta.relationshipKey(startLabelId, typeId, endLabelId), count);
        }

        private void verify(Key key, long actualCount) {
            MutableLong expected = this.counts.remove(key);
            if (expected == null) {
                if (actualCount != 0L) {
                    this.differences.add(new Difference(key, 0L, actualCount));
                }
            } else {
                long expectedCount = expected.longValue();
                if (expectedCount != actualCount) {
                    this.differences.add(new Difference(key, expectedCount, actualCount));
                }
            }
        }

        public List<Difference> differences() {
            for (Map.Entry<Key, MutableLong> entry : this.counts.entrySet()) {
                MutableLong value = entry.getValue();
                this.differences.add(new Difference(entry.getKey(), value.longValue(), 0L));
            }
            this.counts.clear();
            return this.differences;
        }
    }

    public static final class Difference {
        private final Key key;
        private final long expectedCount;
        private final long actualCount;

        public Difference(Key key, long expectedCount, long actualCount) {
            this.expectedCount = expectedCount;
            this.actualCount = actualCount;
            this.key = Objects.requireNonNull(key, "key");
        }

        public String toString() {
            return String.format("%s[%s expected=%d, actual=%d]", this.getClass().getSimpleName(), this.key, this.expectedCount, this.actualCount);
        }

        public Key key() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Difference) {
                Difference that = (Difference)obj;
                return this.actualCount == that.actualCount && this.expectedCount == that.expectedCount && this.key.equals(that.key);
            }
            return false;
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + (int)(this.expectedCount ^ this.expectedCount >>> 32);
            result = 31 * result + (int)(this.actualCount ^ this.actualCount >>> 32);
            return result;
        }
    }
}

